import java.net.*;

// Address class is used to store an IP address and port 
// combination.

public class Address {

  private InetAddress address = null;
  private int         port    = 0;

  public Address(InetAddress address, int port) {
    this.address = address;
    this.port    = port;
  }
 
  public Address(InetAddress address) {
    this.address = address;
  }

  public Address(int port) {
    this.port    = port;
  }

  public InetAddress getAddress() { return(address); }
  public int         getPort() { return(port); }

  public void setPort(int port) {
    this.port    = port;
  }

  public void setAddress(InetAddress address) {
    this.address = address;
  }

  public boolean isComplete() {
    // return true if both IP and port are populated,
    // false otherwise.

    if ((address != null) && (port != 0))
      return(true);
    else 
      return(false);
  }

  public String toString() {
    // return a string representation of the IP/port.

    String str;

    if (address == null) 
      str = "";     
    else
      str = address.getHostAddress();     

    str = str + "/" + port;
  
    return(str);
  }
}
