import java.io.*;
import java.util.*;

// Logger class opens and writes to the log file
// if boolean true is passed as constructor argument.

public class Logger {

  private boolean    logging;
  private FileWriter logfile;

  public Logger(boolean logging) {
    this.logging = logging;
 
    if (logging) {
      try {
        // open logfile for append
        logfile=new FileWriter("reflector.log", true);  
      } catch (IOException e) {
        System.err.println("Error opening log file.");
      }
      log("Reflector started: " + new Date());
    }
  }

  public void log(String str) {
    // write string to logfile

    // if logging disabled return
    if (!logging) return;

    try { 
      logfile.write(str + "\n");
      logfile.flush();
    } catch (IOException e) {
      System.err.println("Error writing to log file.");
    }
  }
}
