import java.net.*;
import java.io.*;

// ReflectorSender creates a unicast or multicast socket
// and is registered to receive incoming packet notifications
// via the PacketListenerInterface. Incoming packets
// are forwarded on the outgoing socket.

public class ReflectorSender extends Thread 
                             implements PacketListenerInterface {
  private InetAddress sendAddr;
  private int         sendPort;
  private int         mode;

  private DatagramSocket ds=null;
  private Logger logger;

  public ReflectorSender(Address a, int mode, Logger logger) {
    sendAddr    = a.getAddress();
    sendPort    = a.getPort();
    this.mode   = mode;
    this.logger = logger;
  }

  public void run() {
    // initialize a DatagramSocket or MulticastSocket
    // based on the mode:

    switch (mode) {
    case Reflector.MODE_MULTI_TO_UNI:
      ds = initUnicastSocket();
      break;
    case Reflector.MODE_UNI_TO_MULTI:
      ds = (DatagramSocket) initMulticastSocket();
      break;
    default:
      break;
    }
  }

  private MulticastSocket initMulticastSocket() {
    // initialize a MulticastSocket

    MulticastSocket mc;
    try {
      mc = new MulticastSocket(sendPort);
    } catch (Exception e) {
      e.printStackTrace();
      return(null);
    }
    return(mc);
  }

  private DatagramSocket initUnicastSocket() {
    // initialize a DatagramSocket

    DatagramSocket ds;
    try {
      ds = new DatagramSocket(sendPort);
    } catch (Exception e) {
      e.printStackTrace();
      return(null);
    }
    return(ds);
  }

  public void packetReceived(DatagramPacket packet) {
    // An incoming packet has been received. Override
    // the old packet addressing to the new outgoing 
    // addressing, send it and log it.

    try {
      packet.setAddress(sendAddr);
      packet.setPort(sendPort);
      ds.send(packet);
      logger.log("Packet forwarded to " +
                 packet.getAddress().getHostAddress() + "/" +
                 packet.getPort() + ", " + packet.getLength() 
                 + " bytes");
    } catch (IOException e) {
      System.err.println("Error sending packet"); 
      e.printStackTrace();
    }
  }
}
