rename popup orig_popup
proc popup {aid ifstyle msgsrc} {
    orig_popup $aid $ifstyle $msgsrc
    catch {
        set win .desc$aid.f
        button $win.f3.data -text "Join w/MControl" -relief raised \
                -command "join_with_mcontrol $aid" -highlightthickness 0
        pack $win.f3.data -after $win.f3.start -side left
    }
}

proc join_with_mcontrol {aid} {
  global ldata
#  set wname .wcfsd$aid
#  catch {destroy $wname}
#  toplevel $wname
#  wm title $wname "Sdr: $ldata($aid,session) advert"

  set session $ldata($aid,session)

#  frame $wname.f
#  label $wname.f.l -text "aid: $aid  session: $session" -width 25
#  pack $wname.f.l -side top -expand true -fill x

  set audio "none"
  set video "none"
  set vat "none"
  for {set mnum 0} {$mnum < $ldata($aid,medianum)} {incr mnum} {
    set mediatype $ldata($aid,$mnum,media)
    if {$mediatype=="video"} {
      set video "$ldata($aid,$mnum,addr)/$ldata($aid,$mnum,port)"
#      label $wname.f.l2 -text "video: $video" -width 25
#      pack $wname.f.l2 -side top -expand true -fill x
    }
    if {$mediatype=="audio"} {
      set audio "$ldata($aid,$mnum,addr)/$ldata($aid,$mnum,port)"
#      label $wname.f.l3 -text "audio: $audio" -width 25
#      pack $wname.f.l3 -side top -expand true -fill x

       set media $ldata($aid,$mnum,media)
       set proto $ldata($aid,$mnum,proto)
       set fmt $ldata($aid,$mnum,fmt)

       global mappings
       global tool_state

       set rule $mappings($media.$proto.$fmt)

       set rulelist {}
       foreach subrule $rule {
         set tool [find_tool [lindex $subrule 0]]
         if {$tool!=""} {
           set tmp enabled
           catch {set tmp $tool_state($media.$proto.$fmt.[lindex $subrule 0])}
           if {$tmp=="enabled"} {
              lappend rulelist [lindex $subrule 0]
           } 
         }
       }
       if {[llength $rulelist]==1} {
          set vat [lindex $rulelist 0]
       } else {
          set vat "vat"
       }
    }
  }

  mcontrol_start_all $aid
  exec mcontrol -a $audio -v $video -t $vat &
}

proc mcontrol_start_all {aid} {
  global ldata
  set success 1
  for {set i 0} {$i < $ldata($aid,medianum)} {incr i} {
    set success [expr [mcontrol_start_media "$aid" $i "start"]&&$success]
  }

  set ldata($aid,is_popped) -1;
  popdown $aid
}

proc mcontrol_start_media {aid mnum mode} {
  global sd_sess ldata
  global sdrversion
#  puts "aid: $aid"
#  puts "mnum: $mnum"
  set ldata($aid,started) 1
  set media $ldata($aid,$mnum,media)
  set sd_sess(sess_id) $aid
  set sd_sess(address) $ldata($aid,multicast)
  set sd_sess(ttl)  $ldata($aid,ttl)
  set sd_sess(name) $ldata($aid,session);

  set sd_sess(media) ""
  for {set i 0} {$i < $ldata($aid,medianum)} {incr i} {
      set sd_sess(media) "$sd_sess(media) $ldata($aid,$i,media)"
  }
  set sd_sess(creator) $ldata($aid,creator)
  set sd_sess(creator_id) $ldata($aid,source)
  set sd_sess(source_id) $ldata($aid,heardfrom)
  set sd_sess(arrival_time) $ldata($aid,theard)
  set sd_sess(start_time) $ldata($aid,starttime)
  set sd_sess(end_time) $ldata($aid,endtime)
  set sd_sess(attributes) ""

  global sd_$media
  set tmp sd_$media\(attributes\)
  set $tmp $ldata($aid,$mnum,vars)
  if {$sdrversion=="v2.5a5"} {
    set tmp sd_$media\(mediakey\)
    if {[info exists ldata($aid,$mnum,mediakey)]} {
      set $tmp $ldata($aid,$mnum,mediakey)
    } else {
      set $tmp ""
    }
  }
  set tmp sd_$media\(port\)
  set $tmp $ldata($aid,$mnum,port)
  set tmp sd_$media\(address\)
  set $tmp $ldata($aid,$mnum,addr)
  if {$sdrversion=="v2.5a5"} {
    set tmp sd_$media\(layers\)
    set $tmp $ldata($aid,$mnum,layers)
  }
  set tmp sd_$media\(ttl\)
  set $tmp $ldata($aid,$mnum,ttl)
  set tmp sd_$media\(proto\)
  set $tmp $ldata($aid,$mnum,proto)
  set tmp sd_$media\(fmt\)
  set $tmp $ldata($aid,$mnum,fmt)
  set tmp sd_$media\(proto\)
  set $tmp $ldata($aid,$mnum,proto)
  set sd_priv($media) 1
  if {$mode=="start"} {
      if {[is_known_media $media]!=-1} {
          if {($media!="video")&&($media!="audio")} {
             return [start_media_tool $aid $media $ldata($aid,$mnum,proto) $ldata($aid,$mnum,fmt) [split $ldata($aid,$mnum,vars) "\n"]]
          } else {
             return 1
          }
      } else {
          msgpopup "Media $media unknown" "The session you tried to join contains a media \"$media\" that I do not know about.  To join this session you need the \"$media\" sdr plug-in module and a media tool capable of joining this session.  \n\nSee \"Help\" for more details of plug-in modules."
          return 0
      }
  } elseif {$mode=="record"} {
      return [record_$media]
  } else {
      puts "unknown mode to start_media: $mode"
      return 0
  }
}
