#!/bin/ksh

print "VERIFYING MCONTROL SETTINGS:"
print

if (whence sdr | wc -l) > /dev/null
then
   print "OK: sdr is in your path at" `whence sdr`
else
   print "WARNING! sdr was not found in your path!"
   print "         Non-fatal error. sdr recommended but not required."
fi
print

if (whence vic | wc -l) > /dev/null
then
   print "OK: vic is in your path at" `whence vic`
else
   print "WARNING! vic was not found in your path!"
   print "         You will not have access to video without the vic tool."
fi
print

if (whence vat | wc -l) > /dev/null
then
   print "OK: vat is in your path at" `whence vat`
   print
   if (whence rat | wc -l) > /dev/null
   then
     print "OK: rat is in your path at" `whence rat`
   else
     print "WARNING! rat was not found in your path!"
     print "         Non-fatal error, vat can be used for audio."
   fi
else
   if (whence rat | wc -l) > /dev/null
   then
     print "WARNING! vat was not found in your path!"
     print "         Non-fatal error, rat can be used for audio."
     print
     print "OK: rat is in your path at" `whence rat`
   else
     print "WARNING! vat and rat were not found in your path!"
     print "         You will not have access to audio without one of these tools."
   fi
fi
print

if (whence rtpplay | wc -l) > /dev/null
then
   print "OK: rtpplay is in your path at" `whence rtpplay`
else
   print "ERROR! rtpplay was not found in your path!"
   print "       FATAL ERROR. mcontrol will not work without rtpplay."
fi
print

if (whence rtpdump | wc -l) > /dev/null
then
   print "OK: rtpdump is in your path at" `whence rtpdump`
else
   print "ERROR! rtpdump was not found in your path!"
   print "       FATAL ERROR. mcontrol will not work without rtpdump."
fi
print

if (whence java | wc -l) > /dev/null
then
   print "OK: java is in your path at" `whence java`
   print "    Your java version must be 1.1 or higher. Your version is:"
   java -version
else
   if (whence jre | wc -l) > /dev/null
   then
       print "OK: java is not in your path, but jre can be used."
       print "OK: jre is in your path at" `whence jre`
       print
#       if (grep "java" sdr.tcl) > /dev/null
#       then
#         mv sdr.tcl sdr.tcl.bak
#         dir=`pwd`
#         nawk "{gsub(/java mcontrol/,"jre -cp $dir"); print}" sdr.tcl.bak > sdr.tcl
#         print "IMPORTANT: Your sdr.tcl file in this directory has been"
#         print "           modified to use jre instead of java. Please recopy"
#         print "           it to home directory's .sdr directory if you "
#         print "           want to use mcontrol with sdr."
#       fi
   else
       print "ERROR! Neither java or jre were not found in your path!"
       print "       FATAL ERROR. mcontrol will not work without java or jre."
   fi
fi
print

if (env | grep PATH | grep `pwd`) > /dev/null
then
   print "OK: your PATH includes the mcontrol directory" `pwd` "."
else
   print "WARNING! mcontrol directory" `pwd` 
   print "         was not found in your PATH."
   print "         Non-fatal error. mcontrol will only work in this directory."
   print "         To correct, add this directory to your PATH."
fi
print

if (env | grep CLASSPATH | grep `pwd`) > /dev/null
then
   print "OK: your CLASSPATH includes the mcontrol directory" `pwd` "."
else
   print "WARNING! mcontrol directory" `pwd`
   print "         was not found in your CLASSPATH."
   print "         Non-fatal error. mcontrol will only work in this directory."
   print "         To correct, add this directory to your CLASSPATH."
fi
print


