/****************************************************************************
* DumpManager.java
*
* PURPOSE
* Controls the storage of an incoming stream to disk via rtpdump.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
* 
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
* 
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/
import java.lang.*;
import java.io.*;

public class DumpManager extends Thread {
 
  private String VicIP, VicPort;
  private String VatIP, VatPort;
  private Process rtpdumpProcessV;
  private Process rtpdumpProcessA;
  private long CurrentFileNo=0; 
  private long OldestFileNo=0; 
  private long MaxFileCount=0; 
  private boolean Running=true; 

  public DumpManager(String VicIP, String VicPort, 
                     String VatIP, String VatPort, long MaxFileCount) {
    this.VicIP = VicIP;
    this.VicPort = VicPort;
    this.VatIP = VatIP;
    this.VatPort = VatPort;
    this.MaxFileCount = MaxFileCount;
  }

  public void run() {
    String execstring;
    Long l;
    Runtime rt;
    File f;

//    System.out.println("Entered run()");
    rt = Runtime.getRuntime();
    while(Running) {
       
//      System.out.println("In run loop()");
      l = new Long(CurrentFileNo);
      if ((VatIP != null) && (VicIP != null)) {
//        System.out.println("Both");
/*        execstring = "/bin/sh -c rtpdump \"-F dump -t 0.5 " + VatIP + "/" +
                     VatPort + " > /tmp/audio." + l.toString() + ".rtp &\" "; */
        execstring = "myrtpdump " + VatIP + " " + VatPort + 
                     " /tmp/audio." + l.toString() + ".rtp & "; 
//        System.out.println("execstring = " + execstring);
        try {
          rtpdumpProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
/*        execstring = "/bin/sh -c \"rtpdump -F dump -t 0.5 " + VicIP + "/" +
                     VicPort + " > /tmp/video." + l.toString() + ".rtp\" "; */
        execstring = "myrtpdump " + VicIP + " " + VicPort + 
                     " /tmp/video." + l.toString() + ".rtp & "; 
//        System.out.println("execstring = " + execstring);
        try {
          rtpdumpProcessV = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpdumpProcessV.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
      } else if (VatIP != null) {
//        System.out.println("Audio only");
/*        execstring = "/bin/sh -c \"rtpdump -F dump -t 0.5 " + VatIP + "/" +
                     VatPort + " > audio." + l.toString() + ".rtp\" "; */
        execstring = "myrtpdump " + VatIP + " " + VatPort + 
                     " /tmp/audio." + l.toString() + ".rtp & "; 
//        System.out.println("execstring = " + execstring);
        try {
          rtpdumpProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpdumpProcessA.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
      } else if (VicIP != null) {
//        System.out.println("Video only");
/*        execstring = "/bin/sh -c \"rtpdump -F dump -t 0.5 " + VicIP + "/" +
                     VicPort + " > video." + l.toString() + ".rtp\" "; */
        execstring = "myrtpdump " + VicIP + " " + VicPort + 
                     " /tmp/video." + l.toString() + ".rtp & "; 
//        System.out.println("execstring = " + execstring);
        try {
          rtpdumpProcessV = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpdumpProcessV.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
      }
      CurrentFileNo++;
      if ((CurrentFileNo - OldestFileNo) >= MaxFileCount) {
        l = new Long(OldestFileNo);
        f = new File("/tmp/audio." + l.toString() + ".rtp");
        f.delete();
        f = null;
        f = new File("/tmp/video." + l.toString() + ".rtp");
        f.delete();
        f = null;
        OldestFileNo++;
        
      }
    }
  }

  public long getBufferSize() {
    long total=0;
    File f1;
    Long l;

    for (long x=OldestFileNo; x <= CurrentFileNo; x++) {
      l = new Long(x);
      if (VicIP != null) { 
        f1 = new File("/tmp/video." + l.toString() + ".rtp");
        total +=  f1.length();
      }
      if (VatIP != null) { 
        f1 = new File("/tmp/audio." + l.toString() + ".rtp");
        total +=  f1.length();
      }
    }
    return(total);
  }

  public void setMaxFileCount(int newmax) {
    MaxFileCount = newmax;
  }

  public void SetVic(String VicIP, String VicPort) {
    this.VicIP = VicIP;
    this.VicPort = VicPort;
  }

  public void SetVat(String VatIP, String VatPort) {
    this.VatIP = VatIP;
    this.VatPort = VatPort;
  }

  public void kill() {
    File f;
    Long l;

    Running = false;

    if (rtpdumpProcessV != null)
      rtpdumpProcessV.destroy();
    if (rtpdumpProcessA != null)
      rtpdumpProcessA.destroy();

    // delete the dump files
    for (long x=OldestFileNo; x <= CurrentFileNo; x++) {
      l = new Long(x);
      if (VicIP != null) { 
        f = new File("/tmp/video." + l.toString() + ".rtp");
        f.delete();
        f = null;
      }
      if (VatIP != null) { 
        f = new File("/tmp/audio." + l.toString() + ".rtp");
        f.delete();
        f = null;
      }
    }
    stop();
  }
}


