/****************************************************************************
* FindFilePath.java
*
* PURPOSE
* Searches for a file in the current working directory and in the class
* path in a (hopefully) OS independent way. 
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.io.*;
import java.util.StringTokenizer;

public class FindFilePath {

  public FindFilePath() {
  }

  public String getPath(String filename) {
    String path, classpath;
    File file;

    // Try current working directory first

    try {
      path = System.getProperty("user.dir");
      file = new File(path, filename);
      if (file.exists()) {
        return(path);
      }
    } catch(Exception e) {}

    // Try looking in classpath

    try {
      classpath = System.getProperty("java.class.path");

      // Break the classpath into individual paths
      StringTokenizer st;
      st = new StringTokenizer(classpath,System.getProperty("path.separator"));

      while (st.hasMoreElements()) {
        path = (String)st.nextElement();
        file = new File(path, filename);
        if (file.exists()) { 
//        System.out.println("Got it");
          return(path);
        }
      }
    } catch(Exception e) {}
      

    return(null);
  }
}
