/****************************************************************************
* GridBagPanel.java
*
* PURPOSE
* A simple extension of a panel with a default GridBagLayout.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;

public class GridBagPanel extends Panel {

  private GridBagLayout layout;
  private GridBagConstraints gbc;

  public GridBagPanel () {
    layout = new GridBagLayout();
    setLayout(layout);

    gbc = new GridBagConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 0;
    gbc.weighty = 0;
  }

  public void addToGridBag(Component c, int x, int y, int w, int h) {
      gbc.gridx = x;
      gbc.gridy = y;
      gbc.gridwidth = w;
      gbc.gridheight = h;
      add(c, gbc);
  }

  public void setFill(String fill) { 
    if (fill.equals("BOTH"))
      gbc.fill = GridBagConstraints.BOTH;
    else if (fill.equals("VERTICAL"))
      gbc.fill = GridBagConstraints.VERTICAL;
    else if (fill.equals("HORIZONTAL"))
      gbc.fill = GridBagConstraints.HORIZONTAL;
    else if (fill.equals("NONE")) 
      gbc.fill = GridBagConstraints.NONE;
    else
      System.out.println("ERROR: setFill(" +fill+ ") is invalid.");
  }

  public void setAnchor(String anchor) { 
    if (anchor.equals("CENTER"))
      gbc.anchor = GridBagConstraints.CENTER;
    else if (anchor.equals("EAST"))
      gbc.anchor = GridBagConstraints.EAST;
    else if (anchor.equals("WEST"))
      gbc.anchor = GridBagConstraints.WEST;
    else if (anchor.equals("NORTH"))
      gbc.anchor = GridBagConstraints.NORTH;
    else
      System.out.println("ERROR: setAnchor(" + anchor + ") is invalid.");
  }

  public void setWeight(double weightx, double weighty) {
    gbc.weightx = weightx;
    gbc.weighty = weighty;
  }
}
