/****************************************************************************
* Help.java
*
* PURPOSE
* Disply help text for MControl.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;
import java.io.*;
import java.awt.event.*;
import java.util.StringTokenizer;

public class Help extends Frame implements ActionListener {

  private Button btnDismiss;
  private mcontrol parent;
  private TextArea txtHelp;

  public Help(mcontrol parent) {
    super("Help");

    this.parent = parent;

    setSize(500,800);
    setLocation(100,35);
    addWindowListener(new WindowAdapter() {
                        public void windowClosing(WindowEvent e) {
                          dismiss();
                        }
                      } );

    setLayout(new BorderLayout());

    txtHelp = new TextArea("",20,20);
    add(txtHelp,BorderLayout.CENTER);

    txtHelp.setText("MControl v1.1b\n\n");
    txtHelp.setText(txtHelp.getText() + "Written by David Makofske " + 
			"and Kevin Almeroth\n"); 

    Font buttonfont = new Font("TimesRoman",Font.BOLD, 14);

    btnDismiss = new Button("Dismiss");
    btnDismiss.addActionListener(this);
    btnDismiss.setFont(buttonfont);
    add(btnDismiss, BorderLayout.SOUTH);

    ReadHelpFile();
    setVisible(true);

  }

  public void actionPerformed(ActionEvent e) {
    Object origin;
    String execstring;
    Runtime rt;

    origin = e.getSource();

    if (origin == btnDismiss) {
      dismiss();
    }
  }
 
  public void dismiss() {
    parent.CloseHelpWin(); 
  }

  public void ReadHelpFile() {
    FindFilePath find = new FindFilePath();
    String path = find.getPath("README.HELP");
    if (path == null) {
      txtHelp.setText("Unable to find README.HELP file.");
      return;
    }
    File f = new File(path,"README.HELP");
    RandomAccessFile rafile;
    try {
      rafile = new RandomAccessFile(f, "r");
    } catch (IOException ioe) {
      txtHelp.setText("Unable to open README.HELP file.");
      return;
    }
    String s;
    try {
      while ((s = rafile.readLine()) != null) { 
        txtHelp.setText(txtHelp.getText() + "\n" + s); 
      }
    } catch (IOException ioe) {
      ioe.printStackTrace();
    }
  }
}
    


