/****************************************************************************
* Menu.java
*
* PURPOSE
* Main Menu of options for MControl.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;
import java.io.*;
import java.awt.event.*;
import java.net.*;

public class Menu extends Frame implements ActionListener, ItemListener {

  private boolean Live, holdLive;
  private BorderedPanel pnlLive, pnlFile, pnlServerMode;
  private CheckboxGroup chkgrpUsage;
  private Checkbox chkLive, chkFile;
  private Button btnAudioFile, btnVideoFile;
  private GridBagPanel pnlButtons;
  private Button btnApply, btnDismiss;
  private Label lblStatus;
  private String VicPort, VicIP, VicTTL, VatPort, VatIP, VatTTL, MinBuf;
  private String VicPid=null, VatPid=null;
  private TextField tfVicPort, tfVicIP, tfVatPort, tfVatIP, tfMinBuf;
  private String userAudioFile="", userVideoFile="";
  private TextField tfAudioFile, tfVideoFile;
  private boolean ServerMode = false;
  private boolean SuppressTools = false;
  private CheckboxGroup chkgrpServerMode;
  private Checkbox chkSingleClient, chkServerMode;
  private TextField tfAudioAddr, tfAudioPort, tfAudioTTL;
  private TextField tfVideoAddr, tfVideoPort, tfVideoTTL;
  private Checkbox chkSuppressTools;
  private mcontrol parent;
  private boolean VicIPModified=false;
  private boolean VicPortModified=false;
  private boolean VatIPModified=false;
  private boolean VatPortModified=false;
  private boolean MinBufModified=false;
  private boolean UsageModified = false;
  private boolean AudioFileModified = false;
  private boolean VideoFileModified = false;

  private boolean ShowWarning = false;

  public Menu(mcontrol parent, String VicIP, String VicPort, 
              String VatIP, String VatPort, String MinBuf, 
              boolean ShowWarning) {
    super("MControl Menu");

    Live = true;
    holdLive = true;

    this.VicIP = VicIP;
    this.VicPort = VicPort;
    this.VicTTL = "";
    this.VatIP = VatIP;
    this.VatPort = VatPort;
    this.VatTTL = "";
    this.MinBuf = MinBuf;
    this.parent = parent;
    this.ShowWarning = ShowWarning;
    this.ServerMode = false;

    userAudioFile="";
    userVideoFile="";

    init();
  }

  public Menu(mcontrol parent, String userAudioFile, String userVideoFile,
              String VicIP, String VicPort, String VicTTL, 
              String VatIP, String VatPort, String VatTTL, 
              boolean ServerMode, boolean SuppressTools) {
    super("MControl Menu");

    Live = false; 
    holdLive = false; 

    this.userAudioFile = userAudioFile;
    this.userVideoFile = userVideoFile;
    this.parent = parent;
    this.ServerMode = ServerMode;
    this.SuppressTools = SuppressTools;

    if (ServerMode) {
      this.VicIP = VicIP;
      this.VicPort = VicPort;
      this.VicTTL = VicTTL;
      this.VatIP = VatIP;
      this.VatPort = VatPort;
      this.VatTTL = VatTTL;
    } else {
      this.VicIP = "";
      this.VicPort = "";
      this.VicTTL = "";
      this.VatIP = "";
      this.VatPort = "";
      this.VatTTL = "";
    }

    MinBuf = "";
    ShowWarning = false;
 
    init();
  }

  private void init() {
    //setSize(385,200);
    setLocation(100,35);

    addWindowListener(new WindowAdapter() { 
                        public void windowClosing(WindowEvent e) { 
                          close();
                        }  
                      } );

    setLayout(new FlowLayout());

    GridBagLayout layout = new GridBagLayout();
    setLayout(layout);

    GridBagConstraints gbc = new GridBagConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;

    Font headingFont = new Font("TimesRoman", Font.BOLD, 13);

    Label lbl1 = new Label(" Use MControl For: ", Label.CENTER);
    lbl1.setFont(headingFont);
    addToGridBag(lbl1, gbc, 0, 0, 1, 1);
    chkgrpUsage = new CheckboxGroup();
    chkLive = new Checkbox("Live MBone Session", chkgrpUsage, Live);
    chkLive.addItemListener(this);
    addToGridBag(chkLive, gbc, 1, 0, 1, 1);
    chkFile = new Checkbox("Existing Rtpdump Files", chkgrpUsage, !Live);
    chkFile.addItemListener(this);
    addToGridBag(chkFile, gbc, 2, 0, 1, 1);

    pnlLive = new BorderedPanel();
    pnlLive.setFill("BOTH");
    pnlLive.setWeight(1.0,1.0);

    Label lbl2 = new Label("Live MBone Session", Label.CENTER);
    lbl2.setFont(headingFont);
    pnlLive.addToGridBag(lbl2, 0, 0, 3, 1);

    pnlLive.addToGridBag(new Label("Video IP Address:",Label.RIGHT), 
                         0, 1, 1, 1);
    if (! ServerMode) 
      tfVicIP = new TextField(VicIP,20);
    else
      tfVicIP = new TextField("",20);
    pnlLive.addToGridBag(tfVicIP, 1, 1, 1, 1);

    pnlLive.addToGridBag(new Label("Video Port:",Label.RIGHT), 0, 2, 1, 1);
    if (! ServerMode) 
      tfVicPort = new TextField(VicPort,6);
    else
      tfVicPort = new TextField("",6);
    pnlLive.addToGridBag(tfVicPort, 1, 2, 1, 1);

    pnlLive.addToGridBag(new Label("Audio IP Address:",Label.RIGHT), 
                         0, 3, 1, 1);
    if (! ServerMode) 
      tfVatIP = new TextField(VatIP,20);
    else
      tfVatIP = new TextField("",20);
    pnlLive.addToGridBag(tfVatIP, 1, 3, 1, 1);

    pnlLive.addToGridBag(new Label("Audio Port:",Label.RIGHT), 0, 4, 1, 1);
    if (! ServerMode) 
      tfVatPort = new TextField(VatPort,6);
    else
      tfVatPort = new TextField("",6);
    pnlLive.addToGridBag(tfVatPort, 1, 4, 1, 1);

    pnlLive.addToGridBag(new Label("Minutes to Buffer:",Label.RIGHT), 
                         0, 5, 1, 1);
    tfMinBuf = new TextField(MinBuf,3);
    pnlLive.addToGridBag(tfMinBuf, 1, 5, 1, 1);

    if (!Live) {
      pnlLive.setEnabled(false);
    }
    addToGridBag(pnlLive, gbc, 0, 1, 3, 6);

    pnlFile = new BorderedPanel();
    pnlFile.setFill("BOTH");
    pnlFile.setWeight(1.0,1.0);

    Label lbl3 = new Label("Existing Rtpdump Files", Label.CENTER);
    lbl3.setFont(headingFont);
    pnlFile.addToGridBag(lbl3, 0, 0, 3, 1);

    pnlFile.addToGridBag(new Label("Audio File:",Label.RIGHT), 
                         0, 1, 1, 1);
    tfAudioFile = new TextField(userAudioFile,20);
    pnlFile.addToGridBag(tfAudioFile, 1, 1, 1, 1);
    btnAudioFile = new Button("Find File...");
    btnAudioFile.addActionListener(this);
    pnlFile.addToGridBag(btnAudioFile, 2, 1, 1, 1);

    pnlFile.addToGridBag(new Label("Video File:",Label.RIGHT), 
                         0, 2, 1, 1);
    tfVideoFile = new TextField(userVideoFile,20);
    pnlFile.addToGridBag(tfVideoFile, 1, 2, 1, 1);
    btnVideoFile = new Button("Find File...");
    btnVideoFile.addActionListener(this);
    pnlFile.addToGridBag(btnVideoFile, 2, 2, 1, 1);

    Label lbl4 = new Label("Mode: ", Label.CENTER);
    lbl4.setFont(headingFont);
    pnlFile.addToGridBag(lbl4, 0, 3, 1, 1);

    chkgrpServerMode = new CheckboxGroup();
    chkSingleClient = new Checkbox("Single Client        ", chkgrpServerMode, 
                                   ! ServerMode);
    chkSingleClient.addItemListener(this);
    pnlFile.addToGridBag(chkSingleClient, 1, 3, 1, 1);

    chkServerMode = new Checkbox("Server                   ", chkgrpServerMode, 
                                 ServerMode);
    chkServerMode.addItemListener(this);
    pnlFile.addToGridBag(chkServerMode, 2, 3, 1, 1);

    if (Live) {
      pnlFile.setEnabled(false);
    }
    addToGridBag(pnlFile, gbc, 0, 7, 3, 3);

    pnlServerMode = new BorderedPanel();

    Label lbl5 = new Label("Server Mode", Label.CENTER);
    lbl5.setFont(headingFont);
    pnlServerMode.addToGridBag(lbl5, 0, 0, 2, 1);

    pnlServerMode.addToGridBag(new Label("Audio MC Address:",Label.RIGHT),
                         0, 1, 1, 1);
    if (ServerMode)
      tfAudioAddr = new TextField(VatIP,20);
    else
      tfAudioAddr = new TextField("",20);
    pnlServerMode.addToGridBag(tfAudioAddr, 1, 1, 1, 1);

    pnlServerMode.addToGridBag(new Label("Audio Port:",Label.RIGHT), 
                               0, 2, 1, 1);
    if (ServerMode)
      tfAudioPort = new TextField(VatPort,6);
    else
      tfAudioPort = new TextField("",6);
    pnlServerMode.addToGridBag(tfAudioPort, 1, 2, 1, 1);

    pnlServerMode.addToGridBag(new Label("Audio TTL:",Label.RIGHT),
                               0, 3, 1, 1);
    if (ServerMode)
      tfAudioTTL = new TextField(VatTTL,3);
    else
      tfAudioTTL = new TextField("",3);
    pnlServerMode.addToGridBag(tfAudioTTL, 1, 3, 1, 1);

    pnlServerMode.addToGridBag(new Label("Video MC Address:",Label.RIGHT),
                               0, 4, 1, 1);
    if (ServerMode)
      tfVideoAddr = new TextField(VicIP,20);
    else
      tfVideoAddr = new TextField("",20);
    pnlServerMode.addToGridBag(tfVideoAddr, 1, 4, 1, 1);

    pnlServerMode.addToGridBag(new Label("Video Port:",Label.RIGHT), 
                               0, 5, 1, 1);
    if (ServerMode)
      tfVideoPort = new TextField(VicPort,6);
    else
      tfVideoPort = new TextField("",6);
    pnlServerMode.addToGridBag(tfVideoPort, 1, 5, 1, 1);

    pnlServerMode.addToGridBag(new Label("Video TTL:",Label.RIGHT),
                               0, 6, 1, 1);
    if (ServerMode)
      tfVideoTTL = new TextField(VicTTL,3);
    else
      tfVideoTTL = new TextField("",3);
    pnlServerMode.addToGridBag(tfVideoTTL, 1, 6, 1, 1);

    chkSuppressTools = new Checkbox("Suppress Audio and Video Tools         ",
                       SuppressTools);
    chkSuppressTools.addItemListener(this);
    pnlServerMode.addToGridBag(chkSuppressTools, 0, 7, 2, 1);

    if (! ServerMode) {
      pnlServerMode.setEnabled(false);
    }
    addToGridBag(pnlServerMode, gbc, 0, 10, 3, 9);

    lblStatus = new Label("",Label.CENTER);
    addToGridBag(lblStatus, gbc, 0, 19, 3, 1);
    lblStatus.setForeground(Color.red);

    pnlButtons = new GridBagPanel();
    pnlButtons.setWeight(1.0,1.0);

    Font buttonfont = new Font("TimesRoman",Font.BOLD, 14);

    btnApply = new Button("Apply");
    btnApply.addActionListener(this);
    btnApply.setFont(buttonfont);
    pnlButtons.addToGridBag(btnApply, 0, 0, 1, 1);

    btnDismiss = new Button("Dismiss");
    btnDismiss.addActionListener(this);
    btnDismiss.setFont(buttonfont);
    pnlButtons.addToGridBag(btnDismiss, 1, 0, 1, 1);

    addToGridBag(pnlButtons, gbc, 0, 20, 3, 1);

    if (ShowWarning) {
      lblStatus.setText("WARNING: changing parameters will dump " + 
                        "any existing buffer!");
      Toolkit.getDefaultToolkit().beep();
      Toolkit.getDefaultToolkit().beep();
      Toolkit.getDefaultToolkit().beep();
    } else {
      if (Live) {
        if ((VatIP == null) && (VicIP == null)) {
           lblStatus.setText("Unable to find video or audio source. " + 
                             "Enter IP/Port above.");
        } else {
           if (((VatPort != null) && (VatPort.length() < 5)) ||
              ((VicPort != null) && (VicPort.length() < 5))) {
             lblStatus.setText("Possible truncated port! Please verify " +
                             "settings and press Apply to begin buffering.");
              Toolkit.getDefaultToolkit().beep();
           } else {
             lblStatus.setText("Please verify settings and press Apply to " +
             			"begin buffering.");
           }
        }
      } else { /* from File */
        if ((userAudioFile.equals("")) && (userVideoFile.equals(""))) {
           lblStatus.setText("No files selected. Select rtpdump files(s)"
                + "and press Apply.");
        } else {
           lblStatus.setText("");
        }
      }
    }

    pack();
    setResizable(false);

    // Center the Menu window on the mcontrol main window
    Dimension menu_dimension = getSize();
    Dimension parent_dimension = parent.getSize();
    Point parent_point = parent.getLocation();

    setLocation(new Point(parent_point.x +
                        ((parent_dimension.width - menu_dimension.width)/2),
                        parent_point.y +
                        ((parent_dimension.height - menu_dimension.height)/2)));
    setVisible(true);
  }

  public void actionPerformed(ActionEvent e) {
    Object origin;

    origin = e.getSource();

    if (origin == btnDismiss) {
      parent.CloseMenuWin();
    }
    if (origin == btnApply) {
      CheckModified();
      if (Validate()) {
        Apply();
        parent.CloseMenuWin();
      }
    }
    if (origin == btnAudioFile) {
      FileDialog fd = new FileDialog(this, "Rtpdump Audio File", 
                                     FileDialog.LOAD);
      fd.show();
      if (fd.getFile() != null)
        tfAudioFile.setText(fd.getDirectory() + fd.getFile());
    }
    if (origin == btnVideoFile) {
      FileDialog fd = new FileDialog(this, "Rtpdump Video File", 
                                     FileDialog.LOAD);
      fd.show();
      if (fd.getFile() != null)
        tfVideoFile.setText(fd.getDirectory() + fd.getFile());
    }
  }

  public void itemStateChanged(ItemEvent e) {
    Object origin = e.getSource();

    if (origin == chkLive) {
      selectLive();
    } else if (origin == chkFile) {
      selectFile();
    } else if (origin == chkSingleClient) {
      selectSingleClient();
    } else if (origin == chkServerMode) {
      selectServerMode();
    } else if (origin == chkSuppressTools) {
      SuppressTools = chkSuppressTools.getState();
    }
  }

  private void selectLive() {
    Live = true;
    pnlFile.setEnabled(false);
    pnlServerMode.setEnabled(false);
    pnlLive.setEnabled(true);
    lblStatus.setText("Select audio and video IP address and port.");
    if (tfMinBuf.getText().length() < 1) {
      MinBuf = "3";
      tfMinBuf.setText("3");
    }
  }

  private void selectFile() {
    Live = false;
    pnlLive.setEnabled(false);
    pnlFile.setEnabled(true);
    if (chkServerMode.getState()) 
      pnlServerMode.setEnabled(true);
    lblStatus.setText("Select rtpdump files to be used.");
  }

  private void selectSingleClient() {
    ServerMode = false;
    SuppressTools = false;
    chkSuppressTools.setState(false);
    pnlServerMode.setEnabled(false);
  } 

  private void selectServerMode() {
    ServerMode = true;
    SuppressTools = true;
    chkSuppressTools.setState(true);
    pnlServerMode.setEnabled(true);
  } 

  public void CheckModified() {
    if (holdLive == Live)
      UsageModified = false;
    else
      UsageModified = true;

    if (!tfVicIP.getText().equals(VicIP)) {
      if ((VicIP == null) && (tfVicIP.getText().length() < 1))
        VicIPModified = false;
      else
        VicIPModified = true;
    }

    if (!tfVicPort.getText().equals(VicPort)) {
      if ((VicPort == null) && (tfVicPort.getText().length() < 1))
        VicPortModified = false;
      else
        VicPortModified = true;
    }

    if (!tfVatIP.getText().equals(VatIP)) {
      if ((VatIP == null) && (tfVatIP.getText().length() < 1))
        VatIPModified = false;
      else
        VatIPModified = true;
    }

    if (!tfVatPort.getText().equals(VatPort)) {
      if ((VatPort == null) && (tfVatPort.getText().length() < 1))
        VatPortModified = false;
      else
        VatPortModified = true;
    }

    if (!tfMinBuf.getText().equals(MinBuf)) 
      MinBufModified = true;
    else
      MinBufModified = false;

    if (!tfAudioFile.getText().equals(userAudioFile)) 
      AudioFileModified = true;
    else
      AudioFileModified = false;

    if (!tfVideoFile.getText().equals(userVideoFile)) 
      VideoFileModified = true;
    else
      VideoFileModified = false;
  }


  public boolean Validate() {
    if (Live) 
      return(ValidateLive());
    else
      return(ValidateFile());
  }

  public boolean ValidateLive() {
    int i;
    InetAddress inet;

    try {  
      i = Integer.parseInt(tfMinBuf.getText());  
    } catch (NumberFormatException nfe) {
      lblStatus.setText("Minutes to Buffer is not a valid number.");
      Toolkit.getDefaultToolkit().beep();
      return(false);
    }
    if ((i < 1) || (i > 999)) {
      lblStatus.setText("Minutes to Buffer is not a valid setting.");
      Toolkit.getDefaultToolkit().beep();
      return(false);
    }

//    FindVicVat();

    if (VicIPModified || VicPortModified) {
      if (tfVicIP.getText().length() > 0) {
        try {
          inet = InetAddress.getByName(tfVicIP.getText());
        } catch (UnknownHostException uhe) {
          lblStatus.setText("Vic IP Address is not a valid IP address.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        if (!inet.isMulticastAddress()) {
          lblStatus.setText("Vic IP Address is not a valid multicast address.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        try {  
          i = Integer.parseInt(tfVicPort.getText());  
        } catch (NumberFormatException nfe) {
          lblStatus.setText("Vic Port is not a valid number.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        if ((i<1024) || (i>65535)) {
          lblStatus.setText("Vic Port is not in valid range.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
      }
/*      if (VicPid == null) {
        lblStatus.setText("Unable to find running video process.");
        return(false);
      }*/
    }

    if (VatIPModified || VatPortModified) {
      if (tfVatIP.getText().length() > 0) {
        try {
          inet = InetAddress.getByName(tfVatIP.getText());
        } catch (UnknownHostException uhe) {
          lblStatus.setText("Vat IP Address is not a valid IP address.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        if (!inet.isMulticastAddress()) {
          lblStatus.setText("Vat IP Address is not a valid multicast address.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        try {  
          i = Integer.parseInt(tfVatPort.getText());  
        } catch (NumberFormatException nfe) {
          lblStatus.setText("Vat Port is not a valid number.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
        if ((i<1024) || (i>65535)) {
          lblStatus.setText("Vat Port is not in valid range.");
          Toolkit.getDefaultToolkit().beep();
          return(false);
        }
      }
/*      if (VatPid == null) {
        lblStatus.setText("Unable to find running audio process.");
        return(false);
      }*/
    }
    return(true);
  }

  public boolean ValidateFile() {
    if ((tfVideoFile.getText().length() < 1) && 
        (tfAudioFile.getText().length() < 1)) {
      lblStatus.setText("No files selected!");
      Toolkit.getDefaultToolkit().beep();
      return(false);
    }
    
    if (tfAudioFile.getText().length() > 0) {
      File f = new File(tfAudioFile.getText());
      if (! f.exists()) {
        lblStatus.setText("Audio File not found...");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
    }
    if (tfVideoFile.getText().length() > 0) {
      File f = new File(tfVideoFile.getText());
      if (! f.exists()) {
        lblStatus.setText("Video File not found...");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
    }

    if (ServerMode) 
      return(ValidateServerMode());

    return(true);
  }

  private boolean ValidateServerMode() {
    int i;
    InetAddress inet;

    if (tfAudioFile.getText().length() > 0) {
      // we have an audio rtpdump file specified, validate the Server Mode
      // audio info:   
      if (tfAudioAddr.getText().length() < 1) {
        lblStatus.setText("Server Mode requires Audio Addr/Port/TTL info.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }

      try {
        inet = InetAddress.getByName(tfAudioAddr.getText());
      } catch (UnknownHostException uhe) {
        lblStatus.setText("Server Audio MC Address is not valid IP address.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if (!inet.isMulticastAddress()) {
        lblStatus.setText("Server Audio MC Address is not valid multicast address.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      try { 
        i = Integer.parseInt(tfAudioPort.getText());
      } catch (NumberFormatException nfe) {
        lblStatus.setText("Server Audio Port is not a valid number.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if ((i<1024) || (i>65535)) {
        lblStatus.setText("Server Audio Port is not in valid range.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      try {
        i = Integer.parseInt(tfAudioTTL.getText());
      } catch (NumberFormatException nfe) {
        lblStatus.setText("Server Audio TTL is not a valid number.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if ((i<1) || (i>255)) {
        lblStatus.setText("Server Audio TTL is not in 1-255 range.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
    }

    if (tfVideoFile.getText().length() > 0) {
      // we have an video rtpdump file specified, validate the Server Mode
      // video info:   
      if (tfVideoAddr.getText().length() < 1) {
        lblStatus.setText("Server Mode requires Video Addr/Port/TTL info.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      try {
        inet = InetAddress.getByName(tfVideoAddr.getText());
      } catch (UnknownHostException uhe) {
        lblStatus.setText("Server Video MC Address is not valid IP address.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if (!inet.isMulticastAddress()) {
        lblStatus.setText("Server Video MC Address is not valid multicast address.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      try { 
        i = Integer.parseInt(tfVideoPort.getText());
      } catch (NumberFormatException nfe) {
        lblStatus.setText("Server Video Port is not a valid number.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if ((i<1024) || (i>65535)) {
        lblStatus.setText("Server Video Port is not in valid range.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      try {
        i = Integer.parseInt(tfVideoTTL.getText());
      } catch (NumberFormatException nfe) {
        lblStatus.setText("Server Video TTL is not a valid number.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
      if ((i<1) || (i>255)) {
        lblStatus.setText("Server Video TTL is not in 1-255 range.");
        Toolkit.getDefaultToolkit().beep();
        return(false);
      }
    }

    return(true);
  }

  public void Apply() {
    if (Live) 
      ApplyLive();
    else
      ApplyFile();

    parent.Resume();
  }

  public void ApplyLive() {
    if ((VicIPModified || VicPortModified) || (holdLive != Live)) {
      if (tfVicIP.getText().length() == 0)
        parent.SetVic(null,null,VicPid);
      else
        parent.SetVic(tfVicIP.getText(),tfVicPort.getText(),VicPid);
    }
    if ((VatIPModified || VatPortModified) || (holdLive != Live)) {
      if (tfVatIP.getText().length() == 0)
        parent.SetVat(null,null,VatPid);
      else
        parent.SetVat(tfVatIP.getText(),tfVatPort.getText(),VatPid);
    }
    if ((MinBufModified) || (holdLive != Live)) {
      parent.SetMinToBuf(tfMinBuf.getText());
    }
  }

  public void ApplyFile() {
    parent.SetAudioFile(tfAudioFile.getText());
    parent.SetVideoFile(tfVideoFile.getText());
    parent.SetServerMode(ServerMode, 
                         tfAudioAddr.getText(),
                         tfAudioPort.getText(),
                         tfAudioTTL.getText(),
                         tfVideoAddr.getText(),
                         tfVideoPort.getText(),
                         tfVideoTTL.getText(),
                         SuppressTools);
  }

  public void close() {
    parent.CloseMenuWin();
  }

  public void addToGridBag(Component c, GridBagConstraints gbc,
                           int x, int y, int w, int h) {
      gbc.gridx = x;
      gbc.gridy = y;
      gbc.gridwidth = w;
      gbc.gridheight = h;
      add(c, gbc);
   }

}
    


