/****************************************************************************
* Meter.java
*
* PURPOSE
* Meter control to display playout position.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;
import java.awt.event.*;
import java.lang.*;

public class Meter extends Canvas implements MouseListener, 
                                             MouseMotionListener {

  private int PercentFull;
  private int PointerLoc;
  private String PointerLabel = null;
  private String LeftLabel = null;
  private String RightLabel = null;
  private Color mygreen;

  private boolean PtrSelected=false;
  private mcontrol parent=null;
  private int HoldCursorX;
  private int OldX;

  // Width of small borders on either side of meter
  final int BORDER_WIDTH = 10;

  // Top of Meter on canvas
  final int METER_TOP = 40;
  
  int METER_HEIGHT;

  private boolean SplitBar = true;

  private double ptrloc;
  private double fillwidth;
  private int canvas_width;

  public Meter(mcontrol parent) {
    this.parent = parent;
    addMouseListener(this);
    addMouseMotionListener(this);
  }

  public void paint(Graphics g) {
    int canvas_height;
    int a;
    FontMetrics fm;

    canvas_width = this.getSize().width - (BORDER_WIDTH *2);
    canvas_height = this.getSize().height;
    METER_HEIGHT = canvas_height - 60;
 
    // draw a bar on the left side
    g.setColor(Color.black);
    g.fillRect (0, METER_TOP, BORDER_WIDTH, METER_HEIGHT);

    // draw a bar on the left side
    g.setColor(Color.black);
    g.fillRect (canvas_width + BORDER_WIDTH, METER_TOP, 
                BORDER_WIDTH, METER_HEIGHT);

    // draw bar outline
    g.setColor(Color.black);
    g.drawRect (BORDER_WIDTH, METER_TOP, canvas_width, METER_HEIGHT);
    
    if (SplitBar) {
      fillwidth = canvas_width * (0.01 * PercentFull);
      ptrloc = canvas_width * (0.01 * PointerLoc);
      g.setColor(Color.blue);
      g.fillRect (BORDER_WIDTH, METER_TOP, (int)ptrloc, METER_HEIGHT);
      mygreen = new Color((float)0.2, (float)0.6, (float)0.2);
      g.setColor(mygreen);
      g.fillRect ((int)ptrloc + BORDER_WIDTH, METER_TOP, 
                  (int)fillwidth - (int)ptrloc, METER_HEIGHT);
      g.setColor(Color.black);
    } else {
      // draw percentage full bar:
      g.setColor(Color.black);
      fillwidth = canvas_width * (0.01 * PercentFull);
      g.fillRect (BORDER_WIDTH, METER_TOP, (int)fillwidth, METER_HEIGHT);
    }

    // draw pointer:
    if (PtrSelected)
      g.setColor(Color.red);
    else
      g.setColor(Color.black);
    ptrloc = canvas_width * (0.01 * PointerLoc);

    if (ptrloc > fillwidth)
      ptrloc = fillwidth;
    if (ptrloc < BORDER_WIDTH)
      ptrloc = BORDER_WIDTH;

    int x[] = new int[3], y[] = new int[3];
    x[0] = (int)ptrloc + BORDER_WIDTH - 4;
    y[0] = 22;
    x[1] = (int)ptrloc + BORDER_WIDTH + 4;
    y[1] = 22;
    x[2] = (int)ptrloc + BORDER_WIDTH;
    y[2] = 38;
    g.fillPolygon(x,y,3);

    // draw pointer label:
    g.setColor(Color.black);
    if (PointerLabel != null) {
       fm = g.getFontMetrics(getFont());
       if (((int)ptrloc + fm.stringWidth(PointerLabel)) > canvas_width) {
         a = canvas_width + BORDER_WIDTH - fm.stringWidth(PointerLabel);
         g.drawString (PointerLabel, a, 15);
       } else 
         g.drawString (PointerLabel, (int)ptrloc, 15);
    }

    // draw left bar label:
    if (LeftLabel != null) {
       if (SplitBar)
         g.setColor(Color.blue);
       else
         g.setColor(Color.black);
       g.drawString (LeftLabel, BORDER_WIDTH, canvas_height - 5);
    }

    // draw right bar label:
    if (RightLabel != null) {
       if (SplitBar)
         g.setColor(mygreen);
       else
         g.setColor(Color.black);
       fm = g.getFontMetrics(getFont());
       a = canvas_width + BORDER_WIDTH - fm.stringWidth(RightLabel);
       g.drawString (RightLabel, a, canvas_height - 5);
    }
  }

  public void processMouseMotionEvent(MouseEvent evt) {
     if ((evt.getID() == MouseEvent.MOUSE_DRAGGED) &&
         (PtrSelected)) {
         int XDiff = evt.getX() - HoldCursorX;
         int NewX = OldX + XDiff;
         if (NewX > (int)fillwidth)
           NewX = (int)fillwidth;
         parent.setTime((int)(((float)NewX*100.0)/(float)canvas_width));
         HoldCursorX = evt.getX();
         OldX = NewX;
     }
    
  }
  public void processMouseEvent(MouseEvent evt) {

     switch (evt.getID()) {
     case MouseEvent.MOUSE_PRESSED:
       if ((evt.getX() >= (int)ptrloc + BORDER_WIDTH - 14) &&
           (evt.getX() <= (int)ptrloc + BORDER_WIDTH + 14) &&
           (evt.getY() >= 12) &&
           (evt.getY() <= 48)) {
         PtrSelected = true;
         parent.PointerSelected();
         HoldCursorX = evt.getX();
         OldX = (int)ptrloc + BORDER_WIDTH;
         repaint();
       }
       break;
     case MouseEvent.MOUSE_RELEASED:
       PtrSelected = false;
       parent.PointerDeselected();
       repaint();
       break;
     }
  }

  public void mouseClicked(MouseEvent evt) {
  }

  public void mousePressed(MouseEvent evt) {
  }

  public void mouseReleased(MouseEvent evt) {
  }

  public void mouseEntered(MouseEvent evt) {
  }

  public void mouseExited(MouseEvent evt) {
  }

  public void mouseDragged(MouseEvent evt) {
  }

  public void mouseMoved(MouseEvent evt) {
  }

  public void setPointer(int pointerLoc, String ptrLabel) {
    PointerLoc = pointerLoc;
    PointerLabel = ptrLabel;

    if (PointerLoc > 100) PointerLoc = 100;
  }

  public void setBar(int percent, String leftLabel, String rightLabel) {
    PercentFull = percent;
    LeftLabel = leftLabel;
    RightLabel = rightLabel;

    if (PercentFull > 100) PercentFull = 100;
  }

  public void draw() {
    repaint();
  }

  public void draw(int percent, String leftLabel, String rightLabel, 
                   int pointer, String ptrLabel) {
    PercentFull = percent;
    PointerLoc = pointer;
    PointerLabel = ptrLabel;
    LeftLabel = leftLabel;
    RightLabel = rightLabel;

    if (PercentFull > 100) PercentFull = 100;
    if (PointerLoc > 100) PointerLoc = 100;

    repaint();
  }

}
