/****************************************************************************
* PlayManager.java
*
* PURPOSE
* Controls the playback of a stream via rtpplay.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.lang.*;
import java.io.*;

public class PlayManager extends Thread {
 
  private String VicIP, VicPort, VicTTL;
  private String VatIP, VatPort, VatTTL;
  private Process rtpplayProcessV;
  private Process rtpplayProcessA;
  private long AbsoluteSec;
  private long RelativeSec;
  private boolean Playing=false;
  private mcontrol parent=null;

  public PlayManager(mcontrol parent,
                     String VicIP, String VicPort, String VicTTL,
                     String VatIP, String VatPort, String VatTTL) {
    this.parent = parent;
    this.VicIP = VicIP;
    this.VicPort = VicPort;
    this.VicTTL = VicTTL;

    this.VatIP = VatIP;
    this.VatPort = VatPort;
    this.VatTTL = VatTTL;
  }

  public void setStart(long AbsoluteSec) {
    this.AbsoluteSec = AbsoluteSec;
  }

  public void run() {
    if (parent.userFile) 
      playUserFile();
    else
      playBufferFile();
  }

  private void playUserFile() {
    String execstring;
    Long abssec;
    Runtime rt;
    File f;
    long SyncSec;
    boolean retry;

    Playing = true;

    rt = Runtime.getRuntime();

    if (AbsoluteSec < 0) AbsoluteSec = 0;
    abssec = new Long(AbsoluteSec);
//    System.out.println("AbsoluteSec = " + abssec.toString());

    while(Playing) {
       
      retry = false;
      if ((SyncSec = Sync()) != -1) {
        AbsoluteSec = SyncSec;

        if (AbsoluteSec < 0) AbsoluteSec = 0;
        abssec = new Long(AbsoluteSec);
//        System.out.println("AbsoluteSec = " + abssec.toString());

        retry = true;
      }

//      System.out.println("In rtpplay loop()");

      if (parent.ptrTime.getMillis() > parent.userFileDuration) 
        return;  // we are at the end of the user file

      if ((VatIP != null) && (VicIP != null)) {
//        System.out.println("Both");
        if (!retry) {
          execstring = "rtpplay -f " + parent.userVideoFile + " -b " + 
                       abssec.toString() + " " + VicIP + "/" + VicPort + 
                       "/" + VicTTL + " & ";
//          System.out.println("execstring = " + execstring);
          try {
            rtpplayProcessV = rt.exec(execstring);
          } catch (IOException ioe) {
            ioe.printStackTrace();
          }
        }
        execstring = "rtpplay -f " + parent.userAudioFile + " -b " + 
                     abssec.toString() + " " + VatIP + "/" + VatPort + 
                     "/" + VatTTL + " ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpplayProcessA.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
     } else if (VatIP != null) {
        execstring = "rtpplay -f " + parent.userAudioFile + " -b " + 
                     abssec.toString() + " " + VatIP + "/" + VatPort + 
                     "/" + VatTTL + " ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        } 
        try {
          rtpplayProcessA.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
     } else if (VicIP != null) {
        execstring = "rtpplay -f " + parent.userVideoFile + " -b " 
                     + abssec.toString() + " " + VicIP + "/" + VicPort + 
                     "/" + VicTTL + " & ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessV = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpplayProcessV.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
      }
    }
  }

  private void playBufferFile() {
    String execstring;
    Long l,l2;
    Runtime rt;
    File f;
    long CurrentFileNo=0;
    long SyncSec;
    boolean retry;

    Playing = true;

    rt = Runtime.getRuntime();

    l = new Long(AbsoluteSec);
//    System.out.println("AbsoluteSec = " + l.toString());

/***    CurrentFileNo = 0;
    RelativeSec = AbsoluteSec;
    while (RelativeSec >= 30) {
      RelativeSec -= 30;
      CurrentFileNo++;
    }
    System.out.println("DEBUG: RelativeSec = " + RelativeSec + 
                       " CurrentFileNo = " + CurrentFileNo);****/

    CurrentFileNo = 0;
    RelativeSec = AbsoluteSec;
    if (RelativeSec < 0) RelativeSec = 0;
    CurrentFileNo += (int)((double)RelativeSec/30.0);
    RelativeSec = RelativeSec % 30;
    
//    System.out.println("DEBUG: RelativeSec = " + RelativeSec + 
//                       " CurrentFileNo = " + CurrentFileNo);

    l = new Long(CurrentFileNo);
    l2 = new Long(RelativeSec);
//    System.out.println("File " + l.toString() + " Sec = " + l2.toString());

    while(Playing) {
       
      retry = false;
      if ((SyncSec = Sync()) != -1) {
        CurrentFileNo--;
        AbsoluteSec = SyncSec;

/***    RelativeSec = AbsoluteSec;
        while (RelativeSec >= 30) {
          RelativeSec -= 30;
        }
    System.out.println("DEBUG: RelativeSec = " + RelativeSec +
                       " CurrentFileNo = " + CurrentFileNo);****/

/*    CurrentFileNo += (int)((double)RelativeSec/30.0);*/
    RelativeSec = AbsoluteSec;
    if (RelativeSec < 0) RelativeSec = 0;
    RelativeSec = RelativeSec % 30;
   
//    System.out.println("DEBUG: RelativeSec = " + RelativeSec +
//                       " CurrentFileNo = " + CurrentFileNo);


        retry = true;
      }
      l = new Long(CurrentFileNo);
      l2 = new Long(RelativeSec);
//      System.out.println("In rtpplay loop()");
      l = new Long(CurrentFileNo);
      if ((VatIP != null) && (VicIP != null)) {
//        System.out.println("Both");
        if (!retry) {
          execstring = "rtpplay -f /tmp/video." + l.toString() + ".rtp " +
                       " -b " + l2.toString() + " " + VicIP + "/" + VicPort + 
                       "/" + VicTTL + " & ";
//          System.out.println("execstring = " + execstring);
          try {
            rtpplayProcessV = rt.exec(execstring);
          } catch (IOException ioe) {
            ioe.printStackTrace();
          }
        }
        execstring = "rtpplay -f /tmp/audio." + l.toString() + ".rtp " +
                     " -b " + l2.toString() + " " + VatIP + "/" + VatPort + 
                     "/" + VatTTL + " ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpplayProcessA.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
     } else if (VatIP != null) {
        execstring = "rtpplay -f /tmp/audio." + l.toString() + ".rtp " +
                     " -b " + l2.toString() + " " + VatIP + "/" + VatPort + 
                     "/" + VatTTL + " ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessA = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        } 
        try {
          rtpplayProcessA.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
     } else if (VicIP != null) {
        execstring = "rtpplay -f /tmp/video." + l.toString() + ".rtp " +
                     " -b " + l2.toString() + " " + VicIP + "/" + VicPort + 
                     "/" + VicTTL + " ";
//        System.out.println("execstring = " + execstring);
        try {
          rtpplayProcessV = rt.exec(execstring);
        } catch (IOException ioe) {
          ioe.printStackTrace();
        }
        try {
          rtpplayProcessV.waitFor();
        } catch (InterruptedException ie) {
          ie.printStackTrace();
        }
      }
      CurrentFileNo++;
      RelativeSec = 0;
      AbsoluteSec = CurrentFileNo * 29;
    }
  }

  public long Sync() {
    long ptr, diff;
    Long l = new Long(AbsoluteSec);
//    System.out.println("AbsoluteSec = " + l.toString());
    while((ptr=parent.getPtrTime()) < AbsoluteSec) {
      l = new Long(ptr);
//      System.out.println("Not equal, PtrTime = " + l.toString());

//      if ((AbsoluteSec - parent.getPtrTime()) > 2) 

        return(parent.getPtrTime());

//      try {
//        sleep(1000); // Sleep for one second
//      } catch (InterruptedException ie) {
//      }
    }
    return(-1);
  }

  public void kill() {
    Playing = false;
    if (rtpplayProcessV != null)
      rtpplayProcessV.destroy();
    if (rtpplayProcessA != null)
      rtpplayProcessA.destroy();
    stop();
  }
}


