/****************************************************************************
* ShellVic.java
*
* PURPOSE
* Controls the shelling of a vic session.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.lang.*; 
import java.io.*; 

public class ShellVic extends Thread {
 
   final int LIVE     = 0,
             PLAYBACK = 1;

   private Process vic_process;
   private String IP, port;
   private String title;
   private int playtype;
   private mcontrol parent;
   private boolean notify=true;

   public ShellVic(mcontrol parent, String IP, String port,
                   String title,int playtype) {
     this.parent = parent;
     this.IP = IP;
     this.port = port;
     this.title = title;
     this.playtype = playtype;
   }

   public void run() {
      String execString, str;
      String execArray[];
      Runtime rt;
      byte[] b = new byte[1000];
      int ArraySize = 4;

      try {
         execArray = new String[ArraySize];
         execArray[0] = new String("vic"); 
         execArray[1] = new String("-t1");
         if (playtype == LIVE) 
           execArray[2] = new String("-C Live: " + title);
         else
           execArray[2] = new String("-C Playback: " + title);
//         execArray[3] = new String("-Xgeometry=+670+15");
         execArray[3] = new String(IP + "/" + port);

         // for debugging, print out all exec args:
/*         for (int x=0; x < ArraySize; x++) {
           System.out.print(execArray[x] + " ");
         }
         System.out.println(" ");*/

         rt = Runtime.getRuntime();
         try {
            // exec vic
            vic_process = rt.exec(execArray);
         } catch (SecurityException se) {
            se.printStackTrace();
         }
         // check for any error
         try {
            InputStream is = vic_process.getErrorStream();
            is.read(b);
            str = new String(b);
//            System.out.println(str);
         } catch (IOException ioe) {
            ioe.printStackTrace();
         }
      } catch(IOException exc) {
         System.out.println(exc.getMessage());
         exc.printStackTrace();
      }
      try {
        vic_process.waitFor();
      } catch (InterruptedException ie) {
        ie.printStackTrace();
      }
      if (notify)
        parent.VicTerminated();
      stop();
   }

   public Process getProcess() {
      notify=false;
      return(vic_process);
   }
}
