/****************************************************************************
* Time1.java
*
* PURPOSE
* Simple class to store and retrieve time to millisecond granularity.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.text.DecimalFormat;

public class Time1 {
   private long millis;

   public Time1 () { setTime(0); }

   public Time1 (long t) { setTime(t); }

   public void setTime (long t) {
      millis = t;
   }

   public void add(long a) {
      millis += a;
   }

   public void subtract(long a) {
      millis -= a;
   }

   public String toString() {
      int hour, min, sec;

      sec = (int)(millis/1000.0);
       
      hour = (int)(sec/3600.0); 
      min = (int)(sec/60.0); 

      if (hour > 0) {
        min = min % 60;
        sec = sec % 60;
      }
      if (min > 0) 
        sec = sec % 60;

      DecimalFormat twoDigits = new DecimalFormat("00");

      return ( twoDigits.format(hour) + ":" + twoDigits.format(min) + ":" +
               twoDigits.format(sec));
   }
  
   public long getMillis() {
      return(millis);
   }
}
