/****************************************************************************
* Timer.java
*
* PURPOSE
* Class that allows a timer to be set and a callback returned on expiration.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* ORIGINAL LICENSE
* The Timer class was taken from Core Java 1.1 Volume 1 by Horstmann and
* Cornell, Sun Microsystems Press. As the license in the book states,
* this class may be freely used for non-commercial use. Commerical use
* is granted under the condition that all developers own a copy of the 
* book. 
*
* WARRANTY
* UCSB makes no warranties or representations, either expressed or 
* implied, with respect to the results containied herein, its quality, 
* merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;
import java.awt.event.*;

class Timer extends Component implements Runnable {
 
  private int interval;
  private TimerListener listener;
  private static EventQueue evtq;
 
  public Timer(int i) {
    interval = i;
    Thread t = new Thread (this);
    t.start();
    evtq = Toolkit.getDefaultToolkit().getSystemEventQueue();
    enableEvents(0);
  }
  
  public void addTimerListener(TimerListener l) {
     listener = l;
  }

  public void removeTimerListener() {
     listener = null;
  }

  public void run() {
    while (true) {
      try {
         Thread.sleep(interval);
      } 
      catch(InterruptedException e) {}
 
      TimerEvent te = new TimerEvent(this);
 
      evtq.postEvent(te);
    }
  }

  public void processEvent(AWTEvent evt) {
    if (evt instanceof TimerEvent) {
       if (listener != null)
          listener.timeElapsed((TimerEvent)evt);
    } else   
       super.processEvent(evt);
  }
  
}
