/****************************************************************************
* mcontrol.java
*
* PURPOSE
* Main module.
*
* MCONTROL
* Written by David Makofske and Kevin Almeroth
* University of California at Santa Barbara
* Department of Computer Science
* Neworking and Multimedia Systems Laboratory
* http://imj.ucsb.edu/mcontrol
*
* COPYRIGHT
* Copyright 1998
* University of California at Santa Barbara
* Networking and Multimedia Systems Lab
* Santa Barbara, CA  93106
* ALL RIGHTS RESERVED
*
* This material may be modified, copied and redistributed, both within
* the recipient's organization and externally, subject to the following
* restrictions:  (a)  The recipient may not derive income from the
* University of California at Santa Barbara (herein "UCSB") information
* itself;  (b)  In any material based on this information, the recipient
* agrees to acknowledge UCSB; (c)  Any copies made of this material must be
* accompanied by the following copyright notice: "Copyright 1998 University
* of California at Santa Barbara. Santa Barbara, CA 93106. All Rights
* Reserved."; and (d)  The recipient agrees to obey all U.S. Government
* restrictions governing redistribution or export of such information.
* These restrictions may apply to redistribution within an international
* organization. UCSB makes no warranties or representations, either
* expressed or implied, with respect to the results containied herein, its
* quality, merchantability, performance or fitness for a particular purpose.
* In no event shall UCSB or its developers, directors, officers, employees
* or affiliates be liable for direct, incidental, indirect, special or
* consequential damages (including damages or loss of business profits,
* business interruption, loss of business information and the like)
* resulting from any defect in this material or its documentation or
* arising out of the use or inability to use this material or accompanying
* documentation even if UCSB, an authorized representative or a UCSB
* affiliate has been advised of the possibility of such damage.  UCSB
* makes no representation or warranty regarding the results obtainable
* through use of this material.  No oral or written information or advice
* given by UCSB, its dealers, distributors, agents, affiliates, developers,
* directors, officers or employees shall create a warranty or in any way
* increase the scope of this warranty.
****************************************************************************/

import java.awt.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;

public class mcontrol extends Frame implements ActionListener, TimerListener {

  final int REWIND  = -1, 
            PAUSE   = 0,
            PLAY    = 1, 
            FF      = 2,
            STOPPED = -99;

  final int LIVE     = 0,
            PLAYBACK = 1;
 
  final int BOTH     = 0,
            VIC_ONLY = 1,
            VAT_ONLY = 2;

  private BorderedPanel pnlVCR;
  private Meter meter;
  private Label lblBlue, lblGreen;
  //private Button btnRewind, btnPause, btnPlay, btnFF;
  private Panel pnlVCRButtons;
  private VCRButton btnRewindBegin, btnRewind, btnPause, btnPlay, btnFF, 
                    btnFFEnd;

  private BorderedPanel pnlStatus;
  private TextField txtAudio, txtMinutes, txtVideo, txtBuffer, txtStatus;
  private Label lblBuffer;
  private Label lblSize;

  private GridBagPanel pnlButtons;
  private Button btnJumpToLive;
  private Button btnMenu, btnHelp, btnQuit;

  private static String VicPid, VideoAddr, VideoPort, VideoTTL;
  private static String VatPid, AudioAddr, AudioPort, AudioTTL;
  private long prevTime;
  public Time1 ptrTime;
  private Time1 headTime, tailTime;
  private Process psProcess;
  private ShellVic shellVic = null;
  private ShellVat shellVat = null;
  private int intStatus = STOPPED;
  private static boolean Video = false;
  private static boolean Audio = false;
  private int MinutesToBuffer=3;
  private String OldPtrLabel=null;
  private static boolean Live=true;
  private static String audioTool=null;
  private static boolean ServerMode=false;
  private static boolean SuppressTools=false;

  private static final String defaultPlaybackAudioAddr = "224.2.253.1";
  private static final String defaultPlaybackAudioPort = "50004";
  private static final String defaultPlaybackAudioTTL = "1";

  private static String PlaybackAudioAddr;
  private static String PlaybackAudioPort;
  private static String PlaybackAudioTTL;

  private static String LiveAudioAddr;
  private static String LiveAudioPort;
  private static String LiveAudioTTL;

  private static final String defaultPlaybackVideoAddr = "224.2.253.2";
  private static final String defaultPlaybackVideoPort = "50002";
  private static final String defaultPlaybackVideoTTL = "1";
 
  private static String PlaybackVideoAddr;
  private static String PlaybackVideoPort;
  private static String PlaybackVideoTTL;
 
  private static String LiveVideoAddr;
  private static String LiveVideoPort;
  private static String LiveVideoTTL;

  private DumpManager dm=null;
  private PlayManager pm=null;

  private Help winHelp=null;
  private Menu winMenu=null;

  private Color mygreen;

  private Timer timer;

  private boolean isPointerSelected=false;

  public static File userAudioFile=null, 
                     userVideoFile=null;
  public static String userAudioFileName="", 
                       userVideoFileName="";
  public static boolean userFile = false;
  public long userFileDuration=0;

  public mcontrol() {
    super("MControl v1.1b");

    setSize(600,350);
    setLocation(80,15);
    addWindowListener(new WindowAdapter() { 
                        public void windowClosing(WindowEvent e) { 
                          Quit();
                        } 
                      } );
 
    if (! ServerMode) {
      PlaybackAudioAddr = defaultPlaybackAudioAddr;
      PlaybackAudioPort = defaultPlaybackAudioPort;
      PlaybackAudioTTL = defaultPlaybackAudioTTL;
      PlaybackVideoAddr = defaultPlaybackVideoAddr;
      PlaybackVideoPort = defaultPlaybackVideoPort;
      PlaybackVideoTTL = defaultPlaybackVideoTTL;
    }

    GridBagLayout layout = new GridBagLayout();
    setLayout(layout);

    GridBagConstraints gbc = new GridBagConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;

    pnlVCR = new BorderedPanel();
    pnlVCR.setFill("BOTH");
    pnlVCR.setWeight(1.0,1.0);
    
    meter = new Meter(this);
    meter.setSize(500,80);
    pnlVCR.addToGridBag(meter, 0, 0, 4, 2);

    lblBlue = new Label("Blue bar is time available for rewind.",
                 Label.LEFT);
    lblBlue.setText("");
    lblBlue.setForeground(Color.blue);
    pnlVCR.addToGridBag(lblBlue, 0, 2, 2, 1);
    mygreen = new Color(0.2f,0.6f,0.2f);
    lblGreen = new Label("Green bar is time available for fast forward.",
                 Label.RIGHT);
    lblGreen.setText("");
    lblGreen.setForeground(mygreen);
    pnlVCR.addToGridBag(lblGreen, 2, 2, 2, 1);

    pnlVCRButtons = new Panel(new FlowLayout());

    //btnRewind = new Button("Rewind");

    FindFilePath find = new FindFilePath();
    String path = find.getPath("rewnbg.gif");

    btnRewindBegin = new VCRButton(path,"rewbnb.gif","rewbnb.gif",false,"|<<");
    btnRewindBegin.addActionListener(this);
    pnlVCRButtons.add(btnRewindBegin);

    btnRewind = new VCRButton(path, "rewnbg.gif","rewnb.gif",false,"<<");
    btnRewind.addActionListener(this);
    pnlVCRButtons.add(btnRewind);
//    pnlVCR.addToGridBag(btnRewind,0,3,1,1);

    //btnPause = new Button("Pause");
    btnPause = new VCRButton(path, "pausenbg.gif","pausenb.gif",false,"||");
    btnPause.addActionListener(this);
    pnlVCRButtons.add(btnPause);
//    pnlVCR.addToGridBag(btnPause,1,3,1,1);

    //btnPlay = new Button("Play");
    btnPlay = new VCRButton(path, "playnbg.gif","playnb.gif",false,">");
    btnPlay.addActionListener(this);
    pnlVCRButtons.add(btnPlay);
//    pnlVCR.addToGridBag(btnPlay,2,3,1,1);

    //btnFF = new Button("Fast Forward");
    btnFF = new VCRButton(path, "ffnbg.gif","ffnb.gif",false,">>");
    btnFF.addActionListener(this);
    pnlVCRButtons.add(btnFF);
//    pnlVCR.addToGridBag(btnFF,3,3,1,1);

    btnFFEnd = new VCRButton(path, "ffenb.gif","ffenb.gif",false,">>|");
    btnFFEnd.addActionListener(this);
    pnlVCRButtons.add(btnFFEnd);

    pnlVCR.addToGridBag(pnlVCRButtons,0,3,4,1);

    addToGridBag(pnlVCR, gbc, 0, 0, 4, 3);
 
    BorderedPanel pnlStatus = new BorderedPanel();
    pnlStatus.setWeight(1.0,1.0);
    pnlStatus.addToGridBag(new Label("Audio: ",Label.RIGHT),0,0,1,1);
    txtAudio = new TextField("none",24);
    txtAudio.setEditable(false);
    pnlStatus.addToGridBag(txtAudio,1,0,1,1);

    if (userFile) {
      lblBuffer = new Label("    Minutes in Buffer: ", Label.RIGHT);
    } else {
      lblBuffer = new Label("Max Minutes to Buffer: ", Label.RIGHT);
    }
    pnlStatus.addToGridBag(lblBuffer,2,0,1,1);

    txtMinutes = new TextField(MinutesToBuffer + "", 3);
    txtMinutes.setEditable(false);
    pnlStatus.addToGridBag(txtMinutes, 3, 0, 1, 1);

    pnlStatus.addToGridBag(new Label("Video: ",Label.RIGHT),0,2,1,1);
    txtVideo = new TextField("none", 24);
    txtVideo.setEditable(false);
    pnlStatus.addToGridBag(txtVideo,1,2,1,1);

    if (userFile) {
      lblSize = new Label("File Size: ",Label.RIGHT);
    } else {
      lblSize = new Label("Current Buffer Size: ",Label.RIGHT);
    }
    pnlStatus.addToGridBag(lblSize,2,2,1,1);

    txtBuffer = new TextField("0 K", 8);
    txtBuffer.setEditable(false);
    pnlStatus.addToGridBag(txtBuffer,3,2,1,1);

    pnlStatus.addToGridBag(new Label("Status: ",Label.RIGHT),0,3,1,1);
    txtStatus = new TextField("");
    txtStatus.setEditable(false);
    pnlStatus.addToGridBag(txtStatus,1,3,3,1);

    addToGridBag(pnlStatus, gbc, 0, 4, 4, 3);

    pnlButtons = new GridBagPanel();
    pnlButtons.setWeight(1.0,1.0);
    Font buttonfont = new Font("TimesRoman",Font.BOLD, 14);

    btnJumpToLive = new Button("Jump To Live");
    btnJumpToLive.addActionListener(this);
    btnJumpToLive.setEnabled(false);
    btnJumpToLive.setFont(buttonfont);
    pnlButtons.addToGridBag(btnJumpToLive, 0, 0, 1, 1);

    btnMenu = new Button("Menu");
    btnMenu.addActionListener(this);
    btnMenu.setFont(buttonfont);
    pnlButtons.addToGridBag(btnMenu, 1, 0, 1, 1);

    btnHelp = new Button("Help");
    btnHelp.addActionListener(this);
    btnHelp.setFont(buttonfont);
    pnlButtons.addToGridBag(btnHelp, 2, 0, 1, 1);

    btnQuit = new Button("Quit");
    btnQuit.addActionListener(this);
    btnQuit.setFont(buttonfont);
    pnlButtons.addToGridBag(btnQuit, 3, 0, 1, 1);

    addToGridBag(pnlButtons, gbc, 0, 8, 4, 1);

    pack();
    setResizable(false);
    setVisible(true);

//    FindVicVat();

    OldPtrLabel = new String("");

    if (userFile) {
      // user has specified their own files...
      processRtpFile();
    }

    if ((!Audio) && (!Video)) {
      intStatus=STOPPED;
      if (userFile) {
        txtStatus.setText("Stopped. Use Menu Button to select Video/" +
                          "Audio files."); 
        winMenu = new Menu(this, userAudioFileName, userVideoFileName,
                           VideoAddr, VideoPort, VideoTTL, 
                           AudioAddr, AudioPort, AudioTTL,
                           ServerMode, SuppressTools);
      } else {
        txtStatus.setText("Stopped. Use Menu Button to locate Video/" +
                          "Audio source."); 
        winMenu = new Menu(this,VideoAddr,VideoPort,AudioAddr,AudioPort,
                           MinutesToBuffer + "", false);
      }
    } else {
      if (audioTool==null) 
        audioTool=new String("vat");
      if (userFile) 
        LaunchVicVat(PLAYBACK, BOTH);
      else
        LaunchVicVat(LIVE, BOTH);

      if (AudioAddr == null) 
        txtAudio.setText("none");
      else {
        if (ServerMode) 
          txtAudio.setText(AudioAddr + "/" + AudioPort + "/" + AudioTTL);
        else
          txtAudio.setText(AudioAddr + "/" + AudioPort);
      }

      if (VideoAddr == null) 
        txtVideo.setText("none");
      else {
        if (ServerMode)
          txtVideo.setText(VideoAddr + "/" + VideoPort + "/" + VideoTTL);
        else
          txtVideo.setText(VideoAddr + "/" + VideoPort);
      }

      Start();
    }
  }

  public void FindVicVat() {
    Runtime rt = Runtime.getRuntime();
    String execstring = new String("ps -ef");
    try {
       psProcess = rt.exec(execstring);
    } catch (IOException ioe) {
       ioe.printStackTrace();
    } 
    try {
      psProcess.waitFor();
    } catch (InterruptedException ie) {
      ie.printStackTrace();
    }
    String str;
    try {
      BufferedReader in = new BufferedReader(new InputStreamReader
                                                (psProcess.getInputStream()));
      str = in.readLine();
      while ( str != null) {

        int i = str.indexOf("vic");
        if (i != -1) {
//           System.out.println("str is <" + str + ">");
           if (parsePS(str,"vic"))
              txtVideo.setText(VideoAddr + "/" + VideoPort);
           else
              txtVideo.setText("none");
        }

        i = str.indexOf("rat");
        if (i != -1) {
//           System.out.println("str is <" + str + ">");
           if (parsePS(str,"rat")) {
              txtAudio.setText(AudioAddr + "/" + AudioPort);
              audioTool = "rat";
           } else
              txtAudio.setText("none");
        }
      
        i = str.indexOf("vat");
        if (i != -1) {
//           System.out.println("str is <" + str + ">");
           if (AudioAddr != null) {
             if (str.indexOf(AudioAddr) != -1) {
               if (parsePS(str,"vat")) {
                  txtAudio.setText(AudioAddr + "/" + AudioPort);
                  audioTool = "vat";
               } else
                  txtAudio.setText("none");
             } 
           } else
             if (parsePS(str,"vat")) {
                txtAudio.setText(AudioAddr + "/" + AudioPort);
                audioTool = "vat";
             } else
                txtAudio.setText("none");
        }
      
        str = in.readLine();
        
      }
    } catch (IOException ioe) {
      ioe.printStackTrace();
    }
  }

  public void Start() {
//      System.out.println("Start()");
    if (userFile) {
      txtStatus.setText("Playing...");
      StartTimers();
      intStatus = PAUSE;
      OldPtrLabel="";
      actionPerformed(new ActionEvent(btnPlay,1001,"Play"));
      intStatus = PLAY;
    } else {
      intStatus=PLAY;
      OldPtrLabel="";
      txtStatus.setText("Buffering...");
      //btnPlay.setForeground(mygreen);
      btnPlay.setOn(true);
      StartBuffering();
      StartTimers();
   }
 }

  public void StartBuffering() {
    if (! userFile) {
      dm = new DumpManager(VideoAddr,VideoPort,AudioAddr,AudioPort,
                           MinutesToBuffer*2+1);
      dm.start();
    }
  }

  public void StartTimers() {
    prevTime = System.currentTimeMillis();
    headTime = new Time1(0);
 
    if (userFile)
      tailTime = new Time1(MinutesToBuffer * 60000);
    else 
      tailTime = new Time1(0);

    ptrTime = new Time1(0);

    timer = new Timer(250); // 1/4 second
    timer.addTimerListener(this);
  }

  public void Stop() {
//    System.out.println("Stop()");
    StopTimers();
    StopPlayback();
    StopBuffering();
    if (!userFile)
      KillVicVat();
    
//    System.out.println("Audio=false");
    intStatus=STOPPED;
    if (userFile)
      txtStatus.setText("Stopped. Use Menu Button to select Video/" +
                        "Audio files."); 
    else
      txtStatus.setText("Stopped. Use Menu Button to locate Video/" +
                        "Audio source."); 

    btnRewindBegin.setOn(false);
    btnRewind.setOn(false);
    btnPause.setOn(false);
    btnPlay.setOn(false);
    btnFF.setOn(false);
    btnFFEnd.setOn(false);
  }

  public void StopBuffering() {
    if (dm != null) {
      dm.kill();
      dm = null;
    }
  }

  public void StopTimers() {
    timer.removeTimerListener();
    timer = null;
  }

  public void StopPlayback() {
    if (pm != null) {
      pm.kill();
      pm = null;
    }
  }

  public void actionPerformed(ActionEvent e) {
    Object origin;
    String execstring;
    Runtime rt;

    origin = e.getSource();

    if (origin == btnQuit) {
      Quit();
    }
    if (origin == btnHelp) {
      if (winHelp == null) 
        winHelp = new Help(this);
      else
        winHelp.toFront();
    }
    if (origin == btnMenu) {
      if (winMenu == null) {
        Integer x = new Integer(MinutesToBuffer);
        if (userFile)
          winMenu = new Menu(this, userAudioFileName, userVideoFileName,
                             VideoAddr, VideoPort, VideoTTL, 
                             AudioAddr, AudioPort, AudioTTL,
                             ServerMode, SuppressTools);
        else
          winMenu = new Menu(this,VideoAddr,VideoPort,AudioAddr,AudioPort,
                             x.toString(), true);
      } else
        winMenu.toFront();
    }
    if ((origin == btnJumpToLive) || (origin == btnFFEnd)) {
      btnJumpToLive.setEnabled(false);
      if (!Live) {
         ptrTime.setTime(tailTime.getMillis());
         if (userFile) {
           actionPerformed(new ActionEvent(btnPause,1001,"Pause"));
         } else {
           txtStatus.setText("Killing playback, " +
                             "jumping to live video/audio...");
           KillVicVat();
           LaunchVicVat(LIVE, BOTH);
           txtStatus.setText("Live video/audio.");
           ButtonPress(PLAY); 
        }
      } else {
         txtStatus.setText("Already live!"); 
      }
    }

    if (intStatus == STOPPED)
      return;

    if (origin == btnRewindBegin) {
      StopPlayback();
      if (Live) {
        KillVicVat();
        LaunchPlaybackVicVat();
      } 
      ptrTime.setTime(headTime.getMillis());
      origin = btnPlay;
      intStatus = PAUSE;
    }
 
    if (origin == btnPause) {
       if (intStatus != PAUSE) {
          ButtonPress(PAUSE); 
          StopPlayback();
          if (Live) {
            KillVicVat();
            LaunchPlaybackVicVat();
          }
       }
    }

    if (origin == btnPlay) {
       if (intStatus != PLAY) {
          ButtonPress(PLAY); 

          pm = new PlayManager(this,VideoAddr,VideoPort,VideoTTL,
                               AudioAddr,AudioPort,AudioTTL);
          pm.setStart(ptrTime.getMillis()/1000);
          pm.start();
       }
    }

    if (origin == btnFF) {
       if (intStatus != FF) {
          ButtonPress(FF); 
          StopPlayback();
          if (Live) {
            KillVicVat();
            LaunchPlaybackVicVat();
          }
       }
    }

    if (origin == btnRewind) {
       if (intStatus != REWIND) {
          ButtonPress(REWIND); 
          StopPlayback();
          if (Live) {
            KillVicVat();
            LaunchPlaybackVicVat();
          }
       }
    }
  }

  private void Quit() {
    if (intStatus != STOPPED) {
      Stop();
    }
    KillVicVat();

    System.exit(0);
  }

  public long getPtrTime() {
    return(ptrTime.getMillis()/1000);
  }

  public void ButtonPress(int NewButton) {
    switch (intStatus) {
    case REWIND:
      //btnRewind.setForeground(Color.black);
      btnRewind.setOn(false);
      break;
    case PAUSE:
      //btnPause.setForeground(Color.black);
      btnPause.setOn(false);
      break;
    case PLAY:
      //btnPlay.setForeground(Color.black);
      btnPlay.setOn(false);
      break;
    case FF:
      //btnFF.setForeground(Color.black);
      btnFF.setOn(false);
      break;
    }
    switch (NewButton) {
    case REWIND:
      //btnRewind.setForeground(mygreen);
      btnRewind.setOn(true);
      txtStatus.setText("Rewinding...");
      break;
    case PAUSE:
      //btnPause.setForeground(mygreen);
      btnPause.setOn(true);
      txtStatus.setText("Paused...");
      break;
    case PLAY:
      //btnPlay.setForeground(mygreen);
      btnPlay.setOn(true);
      if (userFile) 
        txtStatus.setText("Playing...");
      else
        txtStatus.setText("Playing/buffering...");
      break;
    case FF:
      //btnFF.setForeground(mygreen);
      btnFF.setOn(true);
      txtStatus.setText("Fast forwarding...");
      break;
    }

    intStatus = NewButton;
  }

  public void addToGridBag(Component c, GridBagConstraints gbc,
                           int x, int y, int w, int h) {
      gbc.gridx = x;
      gbc.gridy = y;
      gbc.gridwidth = w;
      gbc.gridheight = h;
      add(c, gbc);
   }

  public boolean parsePS(String line, String app) {
    int loc, holdloc;
    String holdpid, holdIP, holdport;
    InetAddress inet;
    int i;
   
    loc = 0;

    while (line.substring(loc,loc+1).equals(" ")) loc++;
 
    holdpid = new String("");
    holdport = new String("");
    holdIP = new String("");

    while (! line.substring(loc,loc+1).equals(" ")) {
       holdpid = holdpid + line.substring(loc,loc+1);
       loc++;
    }
    
    while (line.substring(loc,loc+1).equals(" ")) loc++;
    holdpid = "";
    while (! line.substring(loc,loc+1).equals(" ")) {
       holdpid = holdpid + line.substring(loc,loc+1);
       loc++;
    }

    holdloc = line.lastIndexOf("/");
    if (holdloc == -1) return(false);
    
    Integer I = new Integer(line.length());
//    System.out.println("line len = " + I.toString());
    I = new Integer(holdloc);
//    System.out.println("holdloc = " + I.toString());

    loc = holdloc + 1;
    holdport = "";
    while (! line.substring(loc,loc+1).equals(" ")) {
       holdport = holdport + line.substring(loc,loc+1);
       loc++;
       if (loc < line.length()) {
         holdport = holdport + line.substring(loc);
         break;
       }
    }

    loc = holdloc - 1;
    holdIP = "";
    while (! line.substring(loc,loc+1).equals(" ")) {
       holdIP = line.substring(loc,loc+1) + holdIP;
       loc--;
    }

    // Validate IP and Port
    try {
      inet = InetAddress.getByName(holdIP);
    } catch (UnknownHostException uhe) {
//      System.out.println("Invalid IP = " + holdIP);
      return(false); 
    }
    if (!inet.isMulticastAddress()) {
//      System.out.println("Non-multicast IP = " + holdIP);
      return(false); 
    }
    try {
      i = Integer.parseInt(holdport);
    } catch (NumberFormatException nfe) {
//      System.out.println("Invalid Port = " + holdport);
      return(false);
    }
    if ((i<1) || (i>999999)) {
//      System.out.println("Invalid Port = " + holdport);
      return(false);
    }
    try {
      i = Integer.parseInt(holdpid);
    } catch (NumberFormatException nfe) {
//      System.out.println("Invalid Pid = " + holdpid);
      return(false);
    }

    if (app.equals("vic")) {
      VicPid = holdpid;

      LiveVideoAddr = holdIP;
      LiveVideoPort = holdport;
      LiveVideoTTL = "";

      VideoAddr = LiveVideoAddr;
      VideoPort = LiveVideoPort;
      VideoTTL = LiveVideoTTL;

//      System.out.println("VicPid = " + holdpid + " on " + holdIP +"/" +
//                         holdport);
      Video = true;
    } else if (app.equals("vat")) {
      VatPid = holdpid;

      LiveAudioAddr = holdIP;
      LiveAudioPort = holdport;
      LiveAudioTTL = "";

      AudioAddr = LiveAudioAddr;
      AudioPort = LiveAudioPort;
      AudioTTL = LiveAudioTTL;

//      System.out.println("VatPid = " + holdpid + " on " + holdIP +"/" +
//                         holdport);
//      System.out.println("Audio=true");
      Audio = true;
    } else {
      VatPid = holdpid;

      LiveAudioAddr = holdIP;
      LiveAudioPort = holdport;
      LiveAudioTTL = "";

      AudioAddr = LiveAudioAddr;
      AudioPort = LiveAudioPort;
      AudioTTL = LiveAudioTTL;

//      System.out.println("RatPid = " + holdpid + " on " + holdIP +"/" +
//                         holdport);
//      System.out.println("Audio=true");
      Audio = true;
    } 
    return(true);
  }

  public void timeElapsed(TimerEvent evt) {
    Float f;
    long diff, currTime;
    
    currTime = System.currentTimeMillis();
    diff = currTime - prevTime;
    prevTime = currTime;

    if (!userFile)
      tailTime.add(diff);

    if (tailTime.getMillis() > (MinutesToBuffer * 60000))
      headTime.add(diff);

    if (intStatus == PLAY) {
       ptrTime.add(diff);
       if ((ptrTime.getMillis() > tailTime.getMillis()) && (userFile)) {
         ptrTime.setTime(tailTime.getMillis());
         actionPerformed(new ActionEvent(btnPause,1001,"Pause"));
       }
    }
    if (intStatus == FF) {
       ptrTime.add(1000);
       if (ptrTime.getMillis() > tailTime.getMillis()) {
         if (userFile) {
           ptrTime.setTime(tailTime.getMillis());
           actionPerformed(new ActionEvent(btnPause,1001,"Pause"));
         } else {
           ptrTime.setTime(tailTime.getMillis()-1000); 
           if (! isPointerSelected) {
             ButtonPress(PLAY); 
             pm = new PlayManager(this,VideoAddr,VideoPort,VideoTTL,
                                  AudioAddr,AudioPort,AudioTTL);
             pm.setStart(ptrTime.getMillis()/1000);
             pm.start();
           }
         }
       }
    }
    if (intStatus == REWIND) {
       ptrTime.subtract(1000);
    }

    // Check if we have dropped behind the buffer. 
    // This can happen by rewinding too far or pausing too long
    // while the buffer shifts right.
    if (ptrTime.getMillis() < headTime.getMillis()) {
      // we dropped off the buffer. Set the time to the beginning of 
      // the buffer and switch to play mode
      ptrTime.setTime(headTime.getMillis()); 
      if (! isPointerSelected) {
        txtStatus.setText("Beginning of buffer reached... " +
                          "switching to play!");
        actionPerformed(new ActionEvent(btnPlay,1001,"Play"));
      }
    }

    f = new Float(((float)ptrTime.getMillis()-(float)headTime.getMillis()+
                   1000.0)/ (MinutesToBuffer * 600.0));
    boolean Updated = false;
    if ((!OldPtrLabel.equals(ptrTime.toString())) || (intStatus == PAUSE)) {
      // swap the OldPtrLabel assignment to change ptr values
      if (userFile) 
        OldPtrLabel = ptrTime.toString();
      else 
        OldPtrLabel = "-" + 
           (new Time1(tailTime.getMillis() - ptrTime.getMillis())).toString();
      meter.setPointer(f.intValue(), OldPtrLabel);
      Updated = true;
      if ((! userFile) && (dm != null)) {
        txtBuffer.setText(formatBufferSize(dm.getBufferSize()));
      }
    }

    if ((Updated) || (intStatus == PAUSE)) {
      f = new Float(
                 ((float)tailTime.getMillis()-(float)headTime.getMillis()+
                   1000.0)/(MinutesToBuffer * 600.0));
      meter.setBar(f.intValue(), 
            "Rewind Time Available: " + 
            (new Time1(ptrTime.getMillis() - headTime.getMillis())).toString(),
            "FF Time Available: " +
            (new Time1(tailTime.getMillis() - ptrTime.getMillis())).toString());
      meter.draw();
    }
  }

  public String formatBufferSize(long l) {
    if (l > 1000000) {
      Float f = new Float(((float)l/1000000.0));
      String s = f.toString();
      int point = s.indexOf('.');
      s = s.substring(0,point+2);
      return(s + " Meg");
    } else {
      Integer i = new Integer((int)((float)l/1000.0));
      return(i.toString() + " K");
    }
  }

  public void KillLiveVicVat() {
    String execstring;
    Runtime rt;

    if (VicPid != null) {
      execstring = new String("kill -9 " + VicPid);
      try {
        rt = Runtime.getRuntime();
        rt.exec(execstring);
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
      VicPid = null;
    }
    if (VatPid != null) {
      execstring = new String("kill -9 " + VatPid);
      try {
        rt = Runtime.getRuntime();
        rt.exec(execstring);
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
      VatPid = null;
    }
  }

  public void KillVicVat() {
    KillVic();
    KillVat();
  }

  public void KillVic() {
    String execstring;
    Runtime rt;

/*****
    System.out.println("KillVic()");
    System.out.println("VicPid = " + VicPid); 
    if (shellVic == null)
      System.out.println("shellVic is null");
    else
      System.out.println("shellVic is not null");
******/

    if (VicPid != null) {
      execstring = new String("kill -9 " + VicPid);
      try {
        rt = Runtime.getRuntime();
        rt.exec(execstring);
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
      VicPid = null;
    }
    if (shellVic != null) {
//       System.out.println("Kill sets shellVic to null");
       shellVic.getProcess().destroy();
       shellVic = null;
    }
 }
 
  public void KillVat() {
    String execstring;
    Runtime rt;

/******
    System.out.println("KillVat()");
    System.out.println("VatPid = " + VatPid);
    if (shellVat == null)
      System.out.println("shellVat is null");
    else
      System.out.println("shellVat is not null");
*******/

    if (VatPid != null) {
      execstring = new String("kill -9 " + VatPid);
      try {
        rt = Runtime.getRuntime();
        rt.exec(execstring);
      } catch (IOException ioe) {
        ioe.printStackTrace();
      }
      VatPid = null;
    }

    if (shellVat != null) {
//       System.out.println("Kill sets shellVat to null");
       shellVat.getProcess().destroy();
       shellVat = null;
    }
  }

  public void LaunchPlaybackVicVat() {

    AudioAddr = PlaybackAudioAddr;
    AudioPort = PlaybackAudioPort;
    AudioTTL = PlaybackAudioTTL;

    VideoAddr = PlaybackVideoAddr;
    VideoPort = PlaybackVideoPort;
    VideoTTL = PlaybackVideoTTL;

    btnJumpToLive.setEnabled(true);

    if (SuppressTools)
      return;

    if (Live)
      LaunchVicVat(PLAYBACK, BOTH);
    if (Audio && (shellVat == null))
      LaunchVicVat(PLAYBACK, VAT_ONLY);
    if (Video && (shellVic == null))
      LaunchVicVat(PLAYBACK, VIC_ONLY);
  }

 public void LaunchVicVat(int LiveOrPlayback,int app) {
   if (LiveOrPlayback == LIVE) {
     AudioAddr = LiveAudioAddr;
     AudioPort = LiveAudioPort;
     AudioTTL = LiveAudioTTL;

     VideoAddr = LiveVideoAddr;
     VideoPort = LiveVideoPort;
     VideoTTL = LiveVideoTTL;
   }
   if (LiveOrPlayback == PLAYBACK) {
     AudioAddr = PlaybackAudioAddr;
     AudioPort = PlaybackAudioPort;
     AudioTTL = PlaybackAudioTTL;

     VideoAddr = PlaybackVideoAddr;
     VideoPort = PlaybackVideoPort;
     VideoTTL = PlaybackVideoTTL;
   }

//   System.out.println("LaunchVicVat(" + LiveOrPlayback + ")");
   if (app == VIC_ONLY || app == BOTH) {
     if (Video) {
       if (LiveOrPlayback == LIVE) {
         if (!SuppressTools) {
           shellVic = new ShellVic(this,VideoAddr,VideoPort,"Video",LIVE);
           shellVic.start();
         }
         Live=true;
       } else {
         if (shellVic == null) {
           if (!SuppressTools) {
             shellVic = new ShellVic(this,VideoAddr,VideoPort,
                                     "Video",PLAYBACK);
             shellVic.start();
           }
         }
         Live=false;
       }
     }
   }

   if (app == VAT_ONLY || app == BOTH) {
     if (Audio) {
       if (LiveOrPlayback == LIVE) {
//       System.out.println("LIVE");
//       System.out.println("ShellVat(" + AudioAddr + "," + AudioPort + ",Audio,LIVE,"+audioTool+")");
         if (!SuppressTools) {
           shellVat = new ShellVat(this,AudioAddr,AudioPort,"Audio",LIVE,
                                   audioTool);
           shellVat.start();
         }
         Live=true;
       } else {
//         System.out.println("Not LIVE");
//         System.out.println("ShellVat(" + AudioAddr + ", " + AudioPort + ", Audio,PLAYBACK,"+audioTool+")");
         if (shellVat == null) {
           if (!SuppressTools) {
             shellVat = new ShellVat(this,AudioAddr,AudioPort,
                                     "Audio",PLAYBACK, audioTool);
             shellVat.start();
           }
         }
         Live=false;
       }
     }
   }

 }

  public void CloseMenuWin() {
    winMenu.setVisible(false);
    winMenu.dispose();
    winMenu = null;
  }

  public void CloseHelpWin() {
    winHelp.setVisible(false);
    winHelp.dispose();
    winHelp = null;
  }

  public void SetVic(String VideoAddr, String VideoPort, String VicPid) {
    if (userFile == true) {
      userFile = false;
      KillVicVat();
      lblSize.setText("Current Buffer Size: ");
      lblBuffer.setText("Max Minutes to Buffer: ");
    }

    LiveVideoAddr = VideoAddr;
    LiveVideoPort = VideoPort;
    LiveVideoTTL = "";

    PlaybackVideoAddr = defaultPlaybackVideoAddr;
    PlaybackVideoPort = defaultPlaybackVideoPort;
    PlaybackVideoTTL = defaultPlaybackVideoTTL;

    this.VideoAddr = LiveVideoAddr;
    this.VideoPort = LiveVideoPort;
    this.VideoTTL = LiveVideoTTL;

    this.VicPid = VicPid;
//    System.out.println("VicPid received = " + VicPid);
//    System.out.println("VideoAddr received = " + VideoAddr + "/" + VideoPort);
    if (VideoAddr != null) {
      Video=true;
      Live = true;
      txtVideo.setText(VideoAddr + "/" + VideoPort);
    } else {
      txtVideo.setText("none");
      Video=false;
      KillVic();
    }
  }

  public void SetVat(String AudioAddr, String AudioPort, String VatPid) {
    if (userFile == true) {
      userFile = false;
      KillVicVat();
      lblSize.setText("Current Buffer Size: ");
      lblBuffer.setText("Max Minutes to Buffer: ");
    }

    LiveAudioAddr = AudioAddr;
    LiveAudioPort = AudioPort;
    LiveAudioTTL = "";

    PlaybackAudioAddr = defaultPlaybackAudioAddr;
    PlaybackAudioPort = defaultPlaybackAudioPort;
    PlaybackAudioTTL = defaultPlaybackAudioTTL;

    this.AudioAddr = LiveAudioAddr;
    this.AudioPort = LiveAudioPort;
    this.AudioTTL = LiveAudioTTL;

    this.VatPid = VatPid;
//    System.out.println("VatPid received = " + VatPid);
//    System.out.println("AudioAddr received = " + AudioAddr + "/" + AudioPort);
    if (AudioAddr != null) {
//      System.out.println("Audio = true");
      Audio=true;
      Live = true;
      txtAudio.setText(AudioAddr + "/" + AudioPort);
    } else {
      txtAudio.setText("none");
      Audio=false;
      KillVat();
    }
  }

  public void SetAudioFile(String filename) {
    if (userFile == false) {
      userFile = true;
      KillVicVat();
      lblSize.setText("File Size: ");
      lblBuffer.setText("   Minutes in Buffer: ");
      btnJumpToLive.setEnabled(false);
    }
    Live = false;
    if (filename.length() > 0) {
      userAudioFileName = filename;
      userAudioFile = new File(filename);

      PlaybackAudioAddr = defaultPlaybackAudioAddr;
      PlaybackAudioPort = defaultPlaybackAudioPort;
      PlaybackAudioTTL = defaultPlaybackAudioTTL;

      AudioAddr = PlaybackAudioAddr;
      AudioPort = PlaybackAudioPort;
      AudioTTL = PlaybackAudioTTL;

      Audio = true;
      txtAudio.setText(AudioAddr + "/" + AudioPort + "/" + AudioTTL);
     } else {
      userAudioFileName = "";
      userAudioFile = null;

      PlaybackAudioAddr = null;
      PlaybackAudioPort = null;
      PlaybackAudioTTL = "";

      AudioAddr = PlaybackAudioAddr;
      AudioPort = PlaybackAudioPort;
      AudioTTL = PlaybackAudioTTL;

      Audio = false;
      txtAudio.setText("none");
      KillVat();
     }
  }

  public void SetVideoFile(String filename) {
    if (userFile == false) {
      userFile = true;
      KillVicVat();
      lblSize.setText("File Size: ");
      lblBuffer.setText("   Minutes in Buffer: ");
      btnJumpToLive.setEnabled(false);
    }
    Live = false;

    if (filename.length() > 0) {
      userVideoFileName = filename;
      userVideoFile = new File(filename);

      PlaybackVideoAddr = defaultPlaybackVideoAddr;
      PlaybackVideoPort = defaultPlaybackVideoPort;
      PlaybackVideoTTL = defaultPlaybackVideoTTL;

      VideoAddr = PlaybackVideoAddr;
      VideoPort = PlaybackVideoPort;
      VideoTTL = PlaybackVideoTTL;

      Video = true;
      txtVideo.setText(VideoAddr + "/" + VideoPort + "/" + VideoTTL);
    } else {
      userVideoFileName = "";
      userVideoFile = null;

      PlaybackVideoAddr = null;
      PlaybackVideoPort = null;
      PlaybackVideoTTL = "";

      VideoAddr = PlaybackVideoAddr;
      VideoPort = PlaybackVideoPort;
      VideoTTL = PlaybackVideoTTL;

      Video = false;
      txtVideo.setText("none");
      KillVic();
    }
  }

  public void SetServerMode(boolean ServerMode, String newAudioAddr, 
                            String newAudioPort, String newAudioTTL,
                            String newVideoAddr, String newVideoPort, 
                            String newVideoTTL, boolean SuppressTools) {
     if (this.ServerMode != ServerMode) {
       this.ServerMode = ServerMode;
       KillVicVat();  // we have most likely changed addr and/or port
     }
     if (this.SuppressTools != SuppressTools) {
       this.SuppressTools = SuppressTools;
       if (SuppressTools = true)
         KillVicVat();  // in case we have set suppress tools = true
     }

     if (ServerMode) {
       if (userAudioFile != null) {

         PlaybackAudioAddr = newAudioAddr;
         PlaybackAudioPort = newAudioPort;
         PlaybackAudioTTL = newAudioTTL;

         this.AudioAddr = PlaybackAudioAddr;
         this.AudioPort = PlaybackAudioPort;
         this.AudioTTL = PlaybackAudioTTL;

         txtAudio.setText(AudioAddr + "/" + AudioPort + "/" + AudioTTL);
       } else {
         this.AudioTTL = defaultPlaybackAudioTTL;
       }
       if (userVideoFile != null) {

         PlaybackVideoAddr = newVideoAddr;
         PlaybackVideoPort = newVideoPort;
         PlaybackVideoTTL = newVideoTTL;

         this.VideoAddr = PlaybackVideoAddr;
         this.VideoPort = PlaybackVideoPort;
         this.VideoTTL = PlaybackVideoTTL;

         txtVideo.setText(VideoAddr + "/" + VideoPort + "/" + VideoTTL);
       } else {
         this.VideoTTL = defaultPlaybackVideoTTL;
       }
     } 
  }

  public void Resume() {
    if (userFile)
      processRtpFile();

    if (Audio || Video) {
      if (intStatus == STOPPED) {
        if (audioTool==null)
          audioTool = new String("vat");
        if (userFile)
          LaunchVicVat(PLAYBACK, BOTH);
        else
          LaunchVicVat(LIVE, BOTH);
        Start();
      } else {
        Stop();
        if (userFile)
          LaunchVicVat(PLAYBACK, BOTH);
        else
          LaunchVicVat(LIVE, BOTH);
        Start();
      }
    } else {
      if (intStatus != STOPPED) 
        Stop();
    }
  }

  public void SetMinToBuf(String MinBuf) {
    Integer i = new Integer(MinBuf);
    MinutesToBuffer = i.intValue();
    if (dm == null) {
      dm = new DumpManager(VideoAddr,VideoPort,AudioAddr,AudioPort,
                           MinutesToBuffer*2+1);
    } else {
      dm.setMaxFileCount(MinutesToBuffer*2+1);
    }
    txtMinutes.setText(MinBuf);
  }

  public void PointerSelected() {
    isPointerSelected=true;
    actionPerformed(new ActionEvent(btnPause,1001,"Pause"));
  }

  public void PointerDeselected() {
    isPointerSelected=false;
    actionPerformed(new ActionEvent(btnPlay,1001,"Play"));
  }

  public void setTime(int PtrVal) {
    ptrTime.setTime(PtrVal * (MinutesToBuffer * 600) + headTime.getMillis());
  }

  public void VatTerminated() {
//    System.out.println("VatTerminated");
    shellVat = null;
  }

  public void VicTerminated() {
//    System.out.println("VicTerminated");
    shellVic = null;
  }

  private void processRtpFile() {
    // user has specified their own files...
    long s=0;
    if (userVideoFile != null) {
      s += userVideoFile.length();
    }
    if (userAudioFile != null) {
      s += userAudioFile.length();
    }
    txtBuffer.setText(formatBufferSize(s));
    txtStatus.setText("Scanning RTP file, please wait...");
    ScanRtpFile scan = new ScanRtpFile();
    if (userAudioFile != null)
      userFileDuration = scan.getDuration(userAudioFile);
    else
      userFileDuration = scan.getDuration(userVideoFile);
    if (userFileDuration == 0) {
      System.out.println("Unable to process rtp file");
      System.exit(-1);
    } else
      MinutesToBuffer = (int)Math.ceil(userFileDuration/60000.0);

    txtMinutes.setText(MinutesToBuffer + "" );
  }

  public static boolean checkFile(String filename, String Type) {
    File f = new File(filename);
    if (f.exists()) {
      userFile = true;
      if (Type.equals("video")) {
        userVideoFileName = filename;
        userVideoFile = f;
        Live = false;

        if (! ServerMode) {
          PlaybackVideoAddr = defaultPlaybackVideoAddr;
          PlaybackVideoPort = defaultPlaybackVideoPort;
          PlaybackVideoTTL = defaultPlaybackVideoTTL;
        }

        VideoAddr = PlaybackVideoAddr;
        VideoPort = PlaybackVideoPort;
        VideoTTL = PlaybackVideoTTL;

        Video = true;
      }
      if (Type.equals("audio")) {
        userAudioFileName = filename;
        userAudioFile = f;
        Live = false;

        if (! ServerMode) {
          PlaybackAudioAddr = defaultPlaybackAudioAddr;
          PlaybackAudioPort = defaultPlaybackAudioPort;
          PlaybackAudioTTL = defaultPlaybackAudioTTL;
        }

        AudioAddr = PlaybackAudioAddr;
        AudioPort = PlaybackAudioPort;
        AudioTTL = PlaybackAudioTTL;

        Audio = true;
      }
      return(true);
    } else
      return(false);
  }

  public static boolean parseAddr(String addr, String Type) {
    int holdloc;
    String holdIP, holdPort, holdTTL;
    InetAddress inet;
    int i;

    // expected: string in form of "IP/port"

    holdloc = addr.indexOf("/");
    if (holdloc == -1) return(false);
    holdIP = new String(addr.substring(0,holdloc));
    String temp = new String(addr.substring(holdloc+1));

    // check for a TTL:
    holdloc = temp.indexOf("/");
    if (holdloc == -1) {
      // no ttl specified
      holdPort = temp;
      holdTTL = "1";
    } else {
      holdPort = new String(temp.substring(0,holdloc));
      holdTTL = new String(temp.substring(holdloc+1));
    }
   
    // Validate IP, Port, and TTL
    try {
      inet = InetAddress.getByName(holdIP);
    } catch (UnknownHostException uhe) {
      System.out.println("Invalid IP = " + holdIP);
      return(false);
    }
    if (!inet.isMulticastAddress()) {
      System.out.println("Non-multicast IP = " + holdIP);
      return(false);
    }
    try {
      i = Integer.parseInt(holdPort);
    } catch (NumberFormatException nfe) {
      System.out.println("Invalid Port = " + holdPort);
      return(false);
    }
    if ((i<1024) || (i>65535)) {
      System.out.println("Invalid Port = " + holdPort);
      return(false);
    }
    if ((i % 2) != 0) {
      System.out.println("Port " + holdPort + " invalid, must be even port.");
      return(false);
    }
    try {
      i = Integer.parseInt(holdTTL);
    } catch (NumberFormatException nfe) {
      System.out.println("Invalid TTL = " + holdTTL);
      return(false);
    }
    if ((i<1) || (i>255)) {
      System.out.println("Invalid TTL = " + holdTTL);
      return(false);
    }
    
    if (Type.equals("-a")) {
      if (ServerMode) {
        PlaybackAudioAddr = holdIP;
        PlaybackAudioPort = holdPort;
        PlaybackAudioTTL = holdTTL;

        AudioAddr = PlaybackAudioAddr;
        AudioPort = PlaybackAudioPort;
        AudioTTL = PlaybackAudioTTL;
      } else {
        LiveAudioAddr = holdIP;
        LiveAudioPort = holdPort;
        LiveAudioTTL = holdTTL;

        AudioAddr = LiveAudioAddr;
        AudioPort = LiveAudioPort;
        AudioTTL = LiveAudioTTL;
      }

      Audio = true;
    }
    if (Type.equals("-v")) {
      if (ServerMode) {
        PlaybackVideoAddr = holdIP;
        PlaybackVideoPort = holdPort;
        PlaybackVideoTTL = holdTTL;

        VideoAddr = PlaybackVideoAddr;
        VideoPort = PlaybackVideoPort;
        VideoTTL = PlaybackVideoTTL;
      } else {
        LiveVideoAddr = holdIP;
        LiveVideoPort = holdPort;
        LiveVideoTTL = holdTTL;

        VideoAddr = LiveVideoAddr;
        VideoPort = LiveVideoPort;
        VideoTTL = LiveVideoTTL;
      }
      Video = true;
    }

    return(true);
  }

  public static void Usage() {
    System.out.println("mcontrol: unable to parse options");
    System.out.println("Usage: java mcontrol [-s] [-v VideoAddr/Port/TTL] [-a AudioAddr/Port/TTL] [AudioRtpFile] [VideoRtpFile]");
    System.exit(-1);
  }

  public static void main (String args[]) {
    int x;

    for (x=0; x < args.length; x++) {
//      System.out.println("args[" + x + "] = " + args[x] );
      if (args[x].equals("-s")) {
        ServerMode = true;
        SuppressTools = true;
        continue;
      }
      if (args[x].equals("-a")) {
        if ((x+1) >= args.length) {
          System.out.println("Missing argument to -a...");
          Usage();
        }
        if (! args[x+1].equals("none")) {
          if ((parseAddr(args[x+1],args[x++])) == false)
            Usage();
        } else x++;
        continue;
      }
      if (args[x].equals("-v")) {
        if ((x+1) >= args.length) {
          System.out.println("Missing argument to -v...");
          Usage();
        }
        if (! args[x+1].equals("none")) {
          if ((parseAddr(args[x+1],args[x++])) == false)
            Usage();
        } else x++;
        continue;
      }
      if (args[x].equals("-t")) {
        if (args[x+1].equals("none"))
          audioTool=null;
        else if (args[x+1].equals("vat"))
          audioTool=new String("vat");
        else if (args[x+1].equals("rat"))
          audioTool=new String("rat");
        else
          Usage();
        x++;
        continue;
      }
      String Type;
      if (userAudioFile == null)
        Type = "audio";
      else
        Type = "video";
      if ((checkFile(args[x],Type)) == false) {
        System.out.println("File " + args[x] + " not found..."); 
        Usage();
      }
    }
    if ((userAudioFile != null) && (userVideoFile == null)) {
      // if we've been given an audio file but no video file, initialize
      // all of the video variables to reflect no data.
      userVideoFileName = "";
      userVideoFile = null;

      PlaybackVideoAddr = null;
      PlaybackVideoPort = null;
      PlaybackVideoTTL = "";

      VideoAddr = PlaybackVideoAddr;
      VideoPort = PlaybackVideoPort;
      VideoTTL = PlaybackVideoTTL;

      Video = false;
    }
    if (ServerMode) {
      if ((Video == true) && (userVideoFile == null)) {
        System.out.println("Video address specified without a video file.");
        Usage();
      }
      if (Audio == false) {
        System.out.println("Server Mode (-s) requires an audio file, address, port and ttl.");
        Usage();
      }
      if ((Audio == true) && (userAudioFile == null)) {
        System.out.println("Audio address specified without a audio file.");
        Usage();
      }
    }
    mcontrol mc = new mcontrol();
  }

}
