/* 
     File : Router.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : A specialized TreeNode class that represents an intermediate
            router in the multicast tree.
             
  $Id: Router.java,v 1.2 2000/11/18 04:49:28 robertc Exp $
*/

package mwalk.core;


import java.util.Hashtable;


/**
 * A specialized TreeNode class that represents an intermediate
 * router in the multicast tree.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class Router extends TreeNode {

    /** Serialized version ID */
    static final long serialVersionUID = -2771299019911242104L;


    /**
     * Constructor.
     *
     * @param <code>String</code> router's IP address
     */
    public Router( String ip ) {

	super( ip );

	parents = new Hashtable();
	children = new Hashtable();
    }
}
