/* 
     File : ActivityEvaluator.java
   Author : Robert Chalmers

 Original : January 10, 2000
  Revised : 

  Content : A class used by visitors to determine whether a receiver
            is active by checking the current time against the receiver's 
            period table.
            
  $Id: ActivityEvaluator.java,v 1.2 2000/11/18 04:49:29 robertc Exp $ 
*/

package mwalk.eval;


import mwalk.core.Receiver;
import mwalk.core.Link;


/**
 * A class used by visitors to determine whether a receiver is active by 
 * checking the current time against the receiver's period table.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class ActivityEvaluator {

    /**
     * Default constructor.
     */
    public ActivityEvaluator() {}


    /**
     * Determine whether the given receiver is currently active.
     * Assumes decision is time-independent.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv ) {

	return( recv.isActive() );
    }


    /**
     * Determine whether the given receiver is currently active.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv, long time ) {

	return( recv.isActive( time ) );
    }


    /**
     * Determine whether the given link is currently active.
     * Assumes decision is time-independent.
     *
     * @param <code>Link</code> reference to link to check for activity
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Link link ) {

	return( link.isActive() );
    }


    /**
     * Determine whether the given link is currently active.
     *
     * @param <code>Link</code> reference to link to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Link link, long time ) {

	return( link.isActive( time ) );
    }
}
