/* 
     File : PrimaryPathEvaluator.java
   Author : Robert Chalmers

 Original : January 10, 2000
  Revised : 

  Content : A class used to evaluate active paths as those set by
            the PrimaryPathVisitor.
             
  $Id: PrimaryPathEvaluator.java,v 1.3 2000/11/18 04:49:29 robertc Exp $
*/

package mwalk.eval;


import mwalk.core.Link;


/**
 * A class used to evaluate active paths as those set by
 * the <code>PrimaryPathVisitor</code>.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class PrimaryPathEvaluator extends ActivityEvaluator {

    /**
     * Default constructor.
     */
    public PrimaryPathEvaluator() {}


    /**
     * Determine whether the given link is currently active.
     * Assumes decision is time-independent.
     *
     * @param <code>Link</code> reference to link to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether link is active
     */
    public boolean isActive( Link link ) {

	// check the primary link flag
	return( link.isPrimary() );
    }


    /**
     * Determine whether the given link is currently active.
     *
     * @param <code>Link</code> reference to link to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether link is active
     */
    public boolean isActive( Link link, long time ) {

	// check the primary link flag
	return( link.isPrimary() );
    }
}
