/* 
     File : RandomEvaluator.java
   Author : Robert Chalmers

 Original : January 10, 2000
  Revised : 

  Content : A class used by visitors to determine whether a receiver is active
            by checking markings made by the ReceiverRandomizer and 
            RandomPathVisitor classes.
             
*/

package mwalk.eval;


import mwalk.core.Receiver;
import mwalk.core.Link;


/**
 * A class used by visitors to determine whether a receiver is active by 
 * checking markings made by the ReceiverRandomizer and RandomPathVisitor 
 * classes.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class RandomEvaluator extends ActivityEvaluator {

    /**
     * Default constructor.
     */
    public RandomEvaluator() {}


    /**
     * Determine whether the given receiver is currently active.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv, long time ) {

	// check receivers active flag rather than the normal period table
	return( isActive( recv ) );
    }


    /**
     * Determine whether the given link is currently active.
     *
     * @param <code>Link</code> reference to link to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether link is active
     */
    public boolean isActive( Link link, long time ) {

	// check the link activity flag
	return( isActive( link ) );
    }
}
