/* 
     File : ConfigException.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : Exception that indicates a failure during configuration. 
             
*/

package mwalk.util;


/**
 * Exception that indicates a failure during configuration.
 *
 * @author Robert Chalmers
 * @version 1.0
 */
public class ConfigException extends AbstractException {

    /** exception description preface */	
    private static final String LEAD = "Configuration Exception";


    /**
     * Default constructor.
     */
    public ConfigException() {

	super( LEAD );
    }


    /**
     * Constructor.
     *
     * @param <code>String</code> exception description
     */
    public ConfigException( String s ) {

	super( LEAD, s );
    }


    /**
     * Constructor.
     * 
     * @param <code>String</code> exception description
     * @param <code>Throwable</code> offending exception
     */
    public ConfigException( String desc, Throwable off ) {
	
	super( LEAD, desc, off );
    }
}
