/* 
     File : PeriodException.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : Exception that indicates a failure during period table management. 
             
*/

package mwalk.util;


/**
 * Exception that indicates a failure during period table management.
 *
 * @author Robert Chalmers
 * @version 1.0
 */
public class PeriodException extends AbstractException {

    /** exception description preface */	
    private static final String LEAD = "Period Exception";


    /**
     * Default constructor.
     */
    public PeriodException() {

	super( LEAD );
    }


    /**
     * Constructor.
     *
     * @param <code>String</code> exception description
     */
    public PeriodException( String s ) {

	super( LEAD, s );
    }


    /**
     * Constructor.
     * 
     * @param <code>String</code> exception description
     * @param <code>Throwable</code> offending exception
     */
    public PeriodException( String desc, Throwable off ) {
	
	super( LEAD, desc, off );
    }
}
