/* 
     File : RandomRandomizer.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : Class which randomly selects a number of receivers as being active.
         
  $Id: ReceiverRandomizer.java,v 1.4 2000/11/18 04:49:29 robertc Exp $    
*/

package mwalk.util;


import java.util.Vector;

import mwalk.core.Tree;
import mwalk.core.TreeNode;
import mwalk.core.Receiver;


/**
 * Class which randomly selects a number of receivers as being active.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class ReceiverRandomizer {

    // list of receivers in tree
    protected TreeNode[] recvs = null;
    // number of receivers to mark as active
    protected int active = 1;
    // maximum number of receivers available
    public int max = 1;

    public ReceiverRandomizer() {}

    public ReceiverRandomizer( int active ) {

	this.active = active;
    }


    public int getActive() {

	return( active );
    }

    public int incActive() {

	return( ++active );
    }

    public void setActive( int active ) {

	this.active = active;
    }

    public int maxActive() {

	return( max );
    }


    public void reset( Tree tree ) {

	// get receiver list as an array
	if( recvs == null ) 
	    recvs = TreeNode.toNodeArray( tree.getReceivers(), tree.receivers() );

	// set all receivers to non-active
	for( int r = 0; r < recvs.length; r++ )
	    ((Receiver)recvs[r]).active = false;
    }


    public void randomize( Tree tree ) {

	// clear any current selections
	reset( tree );

	// create a list of available receivers
	Vector avail = TreeNode.toNodeVector( tree.getReceivers(), tree.receivers() );
	try {
	    // set the maximum number of available receivers
	    max = avail.size();

	    // randomly select active receivers
	    for( int i = 0; i < active; i++ ) {
		// compute a random index in list of availbale receivers
		int r = (int)(Math.random() * avail.size());
		// remove selected receiver and mark as active
		Receiver recv = (Receiver)avail.remove( r );
		recv.active = true;
	    }
	} catch( ArrayIndexOutOfBoundsException obe ) {}
    }
}
