/* 
     File : DownVisitor.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : A standard interface used to interact with visitors that
            walk the tree from the top down.
        
  $Id: DownVisitor.java,v 1.3 2000/11/18 04:49:29 robertc Exp $     
*/

package mwalk.visitor;


import java.util.Vector;

import mwalk.core.Tree;
import mwalk.core.TreeNode;
import mwalk.util.VisitException;


/**
 * A standard interface used to interact with visitors that
 * walk the tree from the top down.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public interface DownVisitor extends Visitor {

    /**
     * Whether to walk down the tree.
     *
     * @return <code>boolean</code> whether to walk down the tree
     */
    public boolean walkDown();

    /**
     * Visit the current node prior to visiting children.
     * This method is called if prefix() returns true.
     *
     * @param <code>Tree</code> current tree instance
     * @param <code>TreeNode</code> current node
     * @return <code>Object</code> optional return value to pass back along the path
     * @exception <code>VisitException</code> if a problem ocurred during visit
     */
    public Object visitDown( Tree tree, TreeNode node ) throws VisitException;

    /**
     * Visit the current node after visiting children.
     * This method is called if postfix() returns true.
     *
     * @param <code>Tree</code> current tree instance
     * @param <code>TreeNode</code> current node
     * @param <code>Object</code> list of return values passed back along the path
     * @return <code>Object</code> optional return value to pass back along the path
     * @exception <code>VisitException</code> if a problem ocurred during visit
     */
    public Object visitDown( Tree tree, TreeNode node, Vector list ) throws VisitException;

    /**
     * Get a list of children for the current node applying correct activity
     * semantics.
     *
     * @param <code>Tree</code> current tree instance
     * @param <code>TreeNode</code> current node
     * @return <code>TreeNode[]</code> list of active children nodes
     */
    public TreeNode[] getChildren( Tree tree, TreeNode node );
}
