/* 
     File : MetricCount.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : A class used by the metric visitors to track the metric data.
             
*/

package mwalk.util;


import mwalk.core.*;


/**
 * A class used by the metric visitors to track the metric data.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class MetricCount {

    public boolean fromReceiver = false;
    public int receivers = 0;
    public int ucastLinks = 0;
    public int mcastLinks = 0;
    

    public MetricCount() {}

    public MetricCount( boolean active ) {
	
	fromReceiver = true;
	// if the receiver is active, mark it
	if( active )
	    receivers++;
    }
        
    public MetricCount( int receivers, int ucastLinks, int mcastLinks ) {
	
	this.receivers = receivers;
	this.ucastLinks = ucastLinks;
	this.mcastLinks = mcastLinks;
    } 


    public void add( MetricCount count ) {

	receivers += count.receivers;
	ucastLinks += count.ucastLinks;
	mcastLinks += count.mcastLinks;
    }


    public String toString() {

	return( receivers + "\t" + ucastLinks + "\t" + mcastLinks );
    }
}
