/* 
     File : ArrivalEvaluator.java
   Author : Robert Chalmers

 Original : January 10, 2000
  Revised : 

  Content : A class used by visitors to determine whether a receiver
            is active by checking the current time against the receiver's 
            arrival time.
             
  $Id: ArrivalEvaluator.java,v 1.2 2000/11/18 04:49:29 robertc Exp $
*/

package mwalk.eval;


import mwalk.core.Receiver;


/**
 * A class used by visitors to determine whether a receiver is active by 
 * checking the current time against the receiver's arrival time.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class ArrivalEvaluator extends ActivityEvaluator {

    /**
     * Default constructor.
     */
    public ArrivalEvaluator() {}


    /**
     * Determine whether the given receiver is currently active.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv, long time ) {

	return( recv.hasArrived( time ) );
    }
}
