/* 
     File : BuildException.java
   Author : Robert Chalmers

 Original : December 1999
  Revised :

  Content : Exception that indicates a failure during tree building. 
             
*/

package mwalk.util;


/**
 * Exception that indicates a failure during tree building.
 *
 * @author Robert Chalmers
 * @version 1.0
 */
public class BuildException extends AbstractException {

    /** exception description preface */	
    private static final String LEAD = "Build Exception";


    /**
     * Default constructor.
     */
    public BuildException() {

	super( LEAD );
    }


    /**
     * Constructor.
     *
     * @param <code>String</code> exception description
     */
    public BuildException( String s ) {

	super( LEAD, s );
    }


    /**
     * Constructor.
     * 
     * @param <code>String</code> exception description
     * @param <code>Throwable</code> offending exception
     */
    public BuildException( String desc, Throwable off ) {
	
	super( LEAD, desc, off );
    }
}
