/* 
     File : CountVisitor.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : A compund visitor that runs the link count and degree count
	    visitors using a random sampling of active receivers.
             
  $Id: CountVisitor.java,v 1.5 2000/11/18 04:49:29 robertc Exp $
*/

package mwalk.visitor;


import java.util.Vector;
import java.util.Enumeration;

import mwalk.core.Tree;
import mwalk.core.Config;
import mwalk.eval.PrimaryPathEvaluator;
import mwalk.util.VisitException;


/**
 * A compund visitor that runs the link count and degree count
 * visitors using a random sampling of active receivers.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class CountVisitor extends RandomVisitor {

    public CountVisitor() {

	super( new DegreeCountVisitor() );
    }

    public CountVisitor( int rounds, boolean increment, int incCount ) {

	super( new DegreeCountVisitor(), rounds, increment, incCount );
    }

    public CountVisitor( DownVisitor dv ) {

	super( dv );
    }

    public CountVisitor( DownVisitor dv, int rounds, boolean increment, int incCount ) {

	super( dv, rounds, increment, incCount );
    }

    public boolean init( Tree tree ) {

	if( super.init( tree ) )
	    try {
		// run the link count visitor
		LinkCountVisitor lcv = new LinkCountVisitor();
		lcv.evaluator( new PrimaryPathEvaluator() );
		lcv.init( tree );
		
		tree.walkDown( lcv );

		// print an initial group header in the count data file
		((PrintVisitor)dv).printData( tree, "#@ " + rand.getActive() );

		return( true );
		
	    } catch( VisitException ve ) {
		Config.verbose( ve );
	    }

	return( false );
    }

    public boolean again( Tree tree ) {

	if( super.again( tree ) ) {
	    // print next group header in the count data file
	    ((PrintVisitor)dv).printData( tree, "#@ " + rand.getActive() );
	    return( true );
	}

	return( false );
    }
}
