/* 
     File : Visitor.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : The core interface for all visitors.

  $Id: Visitor.java,v 1.3 2000/11/18 04:49:30 robertc Exp $             
*/

package mwalk.visitor;


import mwalk.core.Tree;
import mwalk.eval.ActivityEvaluator;


/**
 * The core interface for all visitors.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public interface Visitor {

    /**
     * Return the current activity evaluator.
     *
     * @return <code>ActivityEvaluator</code> current evaluator
     */
    public ActivityEvaluator evaluator();

    /**
     * Set the current activity evaluator.
     *
     * @param <code>ActivityEvaluator</code> new evaluator
     */
    public void evaluator( ActivityEvaluator eval ); 

    /**
     * Check whether the visitor is verbose.
     *
     * @return <code>boolean</code> whether visitor is verbose
     */
    public boolean verbose();

    /**
     * Whether to visit prior to visiting parent/children.
     *
     * @return <code>boolean</code> whether to visit prior
     */
    public boolean prefix();

    /**
     * Whether to visit after visiting parent/children.
     *
     * @return <code>boolean</code> whether to visit after
     */    
    public boolean postfix();

    /**
     * Initialize state.
     *
     * @param <code>Tree</code> current tree instance
     */
    public boolean init( Tree tree );

    /**
     * Reset state.
     *
     * @param <code>Tree</code> current tree instance
     */
    public void reset( Tree tree );

    /**
     * Whether to walk the tree again.
     *
     * @param <code>Tree</code> current tree instance
     * @return <code>boolean</code> whether to walk again
     */
    public boolean again( Tree tree );
}
