/* 
     File : DegreeCount.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : A class used by the degree count visitor to track the degree data.
             
*/

package mwalk.util;


import mwalk.core.*;


/**
 * A class used by the degree count visitor to track the degree data.
 *
 * @author Robert Chalmers00
 * @version 1.0 
 */
public class DegreeCount {

    // Whether this count comes from a receiver
    public boolean fromReceiver = false;
    // Number of receivers downstream
    public int receivers = 0;
    // Number of active links
    public int links = 0;
    // Number of active links to receivers (gateway)
    public int glinks = 0;
    

    public DegreeCount() {}

    public DegreeCount( boolean active ) {
	
	fromReceiver = true;
	// if the receiver is active, mark it
	if( active )
	    receivers++;
    }
        
    public DegreeCount( int receivers, int links, int glinks ) {
	
	this.receivers = receivers;
	this.links = links;
	this.glinks = glinks;
    } 


    public void add( DegreeCount count ) {

	receivers += count.receivers;
	if( count.receivers > 0 ) {
	    links++;
	    if( count.fromReceiver )
		glinks++;
	}
    }


    public String toString() {

	return( receivers + "\t" + links + "\t" + glinks );
    }
}
