## 
##     File : java.jar.mk
##   Author : Robert Chalmers
##
## Original : October 13, 1999
##  Revised :
##
##  Content : A set of rules for building jar files from the
##            project class tree.  This file is meant to be 
##            included into source makefiles during processing
##            by automake.
##
##            Individual jar file contents can be defined in
##            separate .jar.* files where the resultant jar 
##            file is created as *.jar.  Each definition file
##            should include a comment as the first line (#) 
##            followed by any numbers of lines each containing
##            the path to a package or set of classes from the
##            project classpath.
##
##            For example, .jar.foo might contain :
##            # A collection of foo bar classes
##            edu/ucsb/foo/bar
##            edu/ucsb/foo/bun/round*.class
##
##            and would be used with `make foo.jar'.
##   
##            This would create a jar file named foo.jar in the
##            project lib path with the etire edu.ucsb.foo.bar 
##            package and the matching classes in edu.ucsb.foo.bun.
##
##            A list of available jar file defintions can be listed
##            with the jarfiles target: `make jarfiles', and all 
##            available definitions can be built using the jars 
##            target: `make jars'.
##
## $Id: java.jar.mk,v 1.5 2001/08/23 05:31:03 robertc Exp $
##

## section include from java.jar.mk

EXTRA_DIST += $(j_jarlist)
CLEANFILES += $(addprefix $(P_LIBPATH_BUILD)/,$(j_jarfiles))

j_jar := cd $(P_CLASSPATH); $(JAVA_BINPATH)/jar -cf $(P_LIBPATH_BUILD)/
# collect a list of definition files and create jar file targets
j_jarlist := $(notdir $(wildcard $(srcdir)/.jar.*))
j_jarfiles := $(patsubst .jar.%,%.jar,$(j_jarlist))


.PHONY: jars $(j_jarfiles)

# this will use all definition files found
jars:
	@if test -n "$(j_jarfiles)"; then \
	  jarfiles="$(j_jarfiles)"; \
	  for jarf in $$jarfiles; do \
	    $(MAKE) $$jarf; \
	  done; \
	fi

# this will print a list of available definitions
jarfiles:
	@echo
	@if test -n "$(j_jarfiles)"; then \
	  echo "available jar files (not counting individual package jars)"; \
	  jarfiles="$(j_jarfiles)"; \
	  for jarf in $$jarfiles; do \
	    jarl=`echo $$jarf | sed -e 's/\.jar//; s/^/\.jar\.&/'`; \
	    echo $$jarf - `cat $(srcdir)/$$jarl | sed -e '1!d; s/#//'`; \
	  done; \
	else \
	  echo "no available jar file definitions"; \
	fi
	@echo

# this will create a separate target for each defined jar file
$(j_jarfiles): % : $(P_LIBPATH_BUILD)/%

$(addprefix $(P_LIBPATH_BUILD)/,$(j_jarfiles)) : $(P_LIBPATH_BUILD)/%.jar : $(P_SRCPATH_BUILD)/.pkg.class $(P_SRCPATH_BUILD)/.pkg.rmi 
	@jars=`cat $(srcdir)/.jar.$* | sed -e '/#/d; s#^#$(P_PKGPATH)/&#' | $(AWK) '{printf "%s ", $$0}'`; \
	echo "$(j_jar)$*.jar $$jars"; \
	$(j_jar)$*.jar $$jars; 

## end included section
