/* 
     File : AbstractException.java
   Author : Robert Chalmers

 Original : December 1999
  Revised : 

  Content : Base class for all MWalk exceptions.
             
*/

package mwalk.util;


/**
 * Base class for all MWalk exceptions.
 * This class provides the standard formatting for error prefaces
 * and embedded exception errors.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public abstract class AbstractException extends Exception {

    /**
     * Constructor.
     *
     * @param <code>String</code> exception description
     */
    public AbstractException( String s ) {

	super( s );
    }


    /**
     * Constructor.
     *
     * @param <code>String</code> exception leader
     * @param <code>String</code> exception description
     */
    public AbstractException( String lead, String desc ) {

	super( lead + ": " + desc );
    }


    /**
     * Constructor.
     * 
     * @param <code>String</code> exception leader
     * @param <code>String</code> exception description
     * @param <code>Throwable</code> offending exception
     */
    public AbstractException( String lead, String desc, Throwable off ) {
	
	super( lead + ": " + desc + "\n\t" + off.getMessage() );
    }
}
