## 
##     File : java.pkg.mk
##   Author : Robert Chalmers
##
## Original : October 13, 1999
##  Revised : January 22, 2001
##            1) Removed -sourcepath from javac command-line since it was
##               causing problems with some javac compilers (v1.3)
##
##  Content : A set of rules for building java source files 
##            within the project class tree.  This file is meant 
##            to be included into source makefiles during 
##            processing by automake.
##
##            This file defines a number of standard targets 
##            that should be available in all source directories
##            which represent java packages.
##
##            Many of the rules depend on the existence of a 
##            special file named .package.  This file should be in 
##            the same directory as the source and should contain
##            a single line with the un-prefaced name of the package.
##            By un-prefaced I mean that any package preface, such
##            as `ucsb.edu.' defined in configure.in should not be
##            included since the makefile will prepend it when 
##            necessary.
##
##            In order for the api to compile correctly, the source
##            directory names must match the package names.
##
##            In each local source Makefile.am, a few variables can 
##            be set to affect to the working of these rules:
##            j_classpath - which is usually set to $JAVA_CLASSPATH
##                          can be changed to reflect a different or
##                          extended classpath.  Any changes should
##                          be relative to the package and not 
##                          dependent on the developer's local 
##                          environment.
##            j_rmi - a list of class names that should have rmic
##                    run to create stubs.  These should be the 
##                    actual class names (without .class extension).
##            j_ignore - a list of class names (as in j_rmi) that 
##                       should be ignored for compilation, rmic, and
##                       when building the api.  This is most useful
##                       for conditional compilations determined at 
##                       configuration time.  To ignore all classes
##                       set j_ignore = $(j_targets).
##
##            Individual makefiles can extend the all target by 
##            defining an all-pkg target which will be referenced
##            as the last part of all-local.
##
##            Targets are available to compile just the .class files
##            as `make class' or classes and rmi stubs as `make rmi'.
##            Individual sources can be built by specifying the class
##            name as a target, `make FooBar' not `make FooBar.class'.
##            The jar target, `make jar' will create a jar file named
##            for the current package comprising the current package and
##            all sub-packages.  Finally, to force a complete re-build
##            use `make package'.
##
##            The standard jar definition targets are included from
##            java.jar.mk (see java.jar.mk for more details).
##
## $Id: java.pkg.mk,v 1.6 2002/05/10 18:07:56 robertc Exp $
##

## section included from java.pkg.mk

EXTRA_DIST += $(j_sources) $(notdir $(wildcard $(srcdir)/.package)) $(notdir $(wildcard $(srcdir)/package.html))
CLEANFILES += .pkg.* $(j_pkgpath)/*.class $(P_LIBPATH_BUILD)/$(j_jarfile) $(srcdir)/*~
SUFFIXES += .java .class

# install targets for source
jsrcdir = $(psrcdir)/$(j_pkgsubpath)
jsrc_DATA = $(j_sources)


j_nojob := @echo > /dev/null

# figure out current package name and path
j_pkg := $(strip $(shell cat $(srcdir)/.package))
j_pkgfull := $(P_PKG).$(j_pkg)
j_pkgsubpath := $(subst .,/,$(j_pkgfull))
j_pkgpath := $(P_CLASSPATH)/$(j_pkgsubpath)

# setup java command lines
j_java = $(JAVA_BINPATH)/java -classpath $(j_classpath)
# !- 01.22.01: Added conditional due to problems with -sourcepath option
#j_javac = $(JAVA_BINPATH)/javac -d $(P_CLASSPATH) -sourcepath $(P_SRCPATH_BUILD) -classpath $(j_classpath)
j_javac = $(JAVA_BINPATH)/javac -d $(P_CLASSPATH) -classpath $(j_classpath)
j_javah = $(JAVA_BINPATH)/javah -classpath $(j_classpath) -jni
j_rmic = (CLASSPATH=$(JAVA_CLASSPATH_EXT):$(j_classpath) $(JAVA_BINPATH)/rmic -d $(P_CLASSPATH) $(j_rmiclass))

# setup special jar build for current package
j_jarfile := $(j_pkg).jar
j_jarpkg = $(j_jar)$(j_jarfile) $(j_pkgsubpath)

# get a list of possible sources and tragets
j_sources := $(notdir $(wildcard $(srcdir)/*.java))
j_targets := $(patsubst %.java,%,$(j_sources))

# weed out those we are to ignore
j_source := $(filter-out $(addsuffix .java,$(j_ignore)),$(j_sources))
# make each source a special target (a.java -> target a)
j_target := $(patsubst %.java,%,$(j_source))

# get a list of class files that are already present
j_builtclass := $(notdir $(wildcard $(j_pkgpath)/*.class))

# build a list of classes to check against 
j_class := $(patsubst %.java,%.class,$(j_source))
# build a list of sources with no existing class
j_noclass := $(patsubst %.class,%.java,$(filter-out $(j_builtclass), $(j_class)))

# build a prefix for jni headers
j_jniprefix := $(subst .,_,$(j_pkgfull))_

# filter out classes that should be ignored from rmi list
j_rmilist := $(filter-out $(j_ignore),$(j_rmi))
# build a list of fully qualified classes to build stubs for
j_rmiclass := $(addprefix $(P_PKG).$(j_pkg).,$(j_rmilist))
# build a list of stub names
j_rmistub := $(patsubst %,%_Stub.class,$(j_rmilist))

# set the path for api build and file to list api packages
j_apipath := $(P_API_SRC)/$(j_pkgsubpath)
j_apipkgs := $(P_API_BUILD)/.pkg.api
j_apisrc := $(shell cd $(srcdir) && pwd)
j_apihtml := package.html


# set search path for class file to the package path 
vpath %.class $(j_pkgpath)

.PHONY: all-pkg class pkg rmi jar prc api-prep $(j_target)

# recompile class files and create rmi stubs
all-local: .pkg.class .pkg.rmi prc all-pkg

# recompile all class files
pkg:
	$(RM) .pkg.*
	$(MAKE) all-local

# freshen class files
class: .pkg.class

# freshen class files and create rmi stubs
rmi: .pkg.class .pkg.rmi

# create package-local jar-file 
jar:
	$(j_jarpkg)

# copy compilable source files into api source path
api-prep:
	@$(mkinstalldirs) $(j_apipath)
	@if test -n "$(j_source)"; then \
	  if ! { test -n "$(j_apisrc)" && $(LN_S) $(addprefix $(j_apisrc)/,$(j_source)) $(j_apipath); }; then \
	    cp $(addprefix $(srcdir)/,$(j_source)) $(j_apipath); \
	  fi; \
	  if ! grep "$(j_pkgfull)" $(j_apipkgs) > /dev/null 2>&1; then \
	    echo "$(j_pkgfull)" >> $(j_apipkgs); \
	  fi; \
	fi
	@if test -f "$(srcdir)/$(j_apihtml)"; then \
	  if ! $(LN_S) $(j_apisrc)/$(j_apihtml) $(j_apipath); then \
	    cp $(srcdir)/$(j_apihtml) $(j_apipath); \
	  fi; \
	fi

# special target for each class file (minus .class extension)
$(j_target): 
	(cd $(P_SRCPATH); $(j_javac) $(j_pkgsubpath)/$@.java)


# update class files, use .pkg.class file to record time of last make
.pkg.class: $(j_class)
	@if test -n "$(j_class)"; then \
	  j_javac_src="$(addprefix $(j_pkgsubpath)/,$(sort $(j_noclass) $(patsubst %.class,%.java,$(notdir $?))))"; \
	  echo "$(j_javac) $$j_javac_src"; \
	  (cd $(P_SRCPATH); $(j_javac) $$j_javac_src); \
	else \
	  echo "make: Nothing to be done for \`class'."; \
	fi
	@touch .pkg.class
	@touch $(P_SRCPATH_BUILD)/.pkg.class

# update class stub and skeleton files, use .pkg.rmi file to record time of last make
.pkg.rmi: $(j_rmistub)
	@if test -n "$(j_rmilist)"; then \
	  echo "$(j_rmic)"; \
	  $(j_rmic); \
	else \
	  echo "make: Nothing to be done for \`rmi'."; \
	fi
	@touch .pkg.rmi
	@touch $(P_SRCPATH_BUILD)/.pkg.rmi

# do nothing, just force calling targets to re-make if any changes here
%.class:: %.java
	$(j_nojob)

%_Stub.class:: %.class
	$(j_nojob)

# create the header file for the jni class
$(j_jniprefix)%.h: .pkg.class
	$(j_javah) $(patsubst %.h,%,$(subst _,.,$@))

## end included section

## include rules for jar files
include $(top_srcdir)/src/java.jar.mk

