/* 
     File : PrimaryTreeEvaluator.java
   Author : Robert Chalmers

 Original : May 09, 2002
  Revised : 

  Content : A class used to evaluate the entire primary tree.
             
  $Id: PrimaryTreeEvaluator.java,v 1.1 2002/05/10 18:07:57 robertc Exp $
*/

package mwalk.eval;


import mwalk.core.Receiver;


/**
 * A class used to evaluate the entire primary tree.
 * It extends the primary path visitor to also active all receivers.
 *
 * @author Robert Chalmers
 * @version 1.0 
 */
public class PrimaryTreeEvaluator extends PrimaryPathEvaluator {

    /**
     * Default constructor.
     */
    public PrimaryTreeEvaluator() {}

    /**
     * Determine whether the given receiver is currently active.
     * Assumes decision is time-independent.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv ) {

	return( true );
    }


    /**
     * Determine whether the given receiver is currently active.
     *
     * @param <code>Receiver</code> reference to receiver to check for activity
     * @param <code>long</code> the current time
     * @return <code>boolean</code> whether receiver is active
     */
    public boolean isActive( Receiver recv, long time ) {

	return( true );
    }
}
