/* 
     File : VisitException.java
   Author : Robert Chalmers

 Original : December 1999
  Revised :

  Content : Exception that indicates a failure during tree walking. 
             
*/

package mwalk.util;


/**
 * Exception that indicates a failure during tree walking.
 *
 * @author Robert Chalmers
 * @version 1.0
 */
public class VisitException extends AbstractException {

    /** exception description preface */	
    private static final String LEAD = "Visit Exception";


    /**
     * Default constructor.
     */
    public VisitException() {

	super( LEAD );
    }


    /**
     * Constructor.
     *
     * @param <code>String</code> exception description
     */
    public VisitException( String s ) {

	super( LEAD, s );
    }


    /**
     * Constructor.
     * 
     * @param <code>String</code> exception description
     * @param <code>Throwable</code> offending exception
     */
    public VisitException( String desc, Throwable off ) {
	
	super( LEAD, desc, off );
    }
}
